/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher.icons;

import hubolauncher.Options;
import hubolauncher.Utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class ScalableIcon {
    public final Options options;
    public final Image[] icons;

    public ScalableIcon(Options options, String baseName) {
        this(options, ScalableIcon.class, baseName);
    }

    public ScalableIcon(Options options, Class<?> c, String baseName) {
        this.options = options;
        this.icons = this.readIcon(c, baseName, ".png");
    }

    private Image[] readIcon(Class<?> c, String baseName, String ext) {
        InputStream stream;
        String fname1 = String.valueOf(baseName) + "_x1" + ext;
        URL x1 = c.getResource(fname1);
        Image image1 = null;
        String fname2 = String.valueOf(baseName) + "_x2" + ext;
        URL x2 = c.getResource(fname2);
        Image image2 = null;
        if (x1 == null && x2 == null) {
            throw new RuntimeException("Neither \"" + fname1 + "\" or \"" + fname2 + "\" exist (package=\"" + c.getPackage().getName() + "\")");
        }
        if (x1 != null) {
            stream = null;
            try {
                try {
                    stream = x1.openStream();
                    image1 = ImageIO.read(stream);
                }
                catch (IOException err) {
                    throw new RuntimeException("Failed to read icon " + x1, err);
                }
            }
            finally {
                Utils.close(stream);
            }
        }
        if (x2 != null) {
            stream = null;
            try {
                try {
                    stream = x2.openStream();
                    image2 = ImageIO.read(stream);
                }
                catch (IOException err) {
                    throw new RuntimeException("Failed to read icon " + x2, err);
                }
            }
            finally {
                Utils.close(stream);
            }
        }
        if (x1 == null) {
            image1 = image2.getScaledInstance(image2.getWidth(null) / 2, image2.getHeight(null) / 2, 4);
        }
        if (x2 == null) {
            image2 = image1.getScaledInstance(((Image)image1).getWidth(null) * 2, ((Image)image1).getHeight(null) * 2, 8);
        }
        return new Image[]{image1, image2};
    }

    public Image image() {
        return this.icons[this.options.getUIScale() - 1];
    }

    public void colorize(Color colorize) {
        int i = 0;
        while (i < this.icons.length) {
            BufferedImage bi;
            if (!(this.icons[i] instanceof BufferedImage) || ((BufferedImage)this.icons[i]).getType() != 6) {
                bi = new BufferedImage(this.icons[i].getWidth(null), this.icons[i].getHeight(null), 6);
                Graphics g = bi.getGraphics();
                g.drawImage(this.icons[i], 0, 0, null);
                g.dispose();
                this.icons[i].flush();
                this.icons[i] = bi;
            }
            bi = (BufferedImage)this.icons[i];
            byte r = (byte)colorize.getRed();
            byte g = (byte)colorize.getGreen();
            byte b = (byte)colorize.getBlue();
            byte[] data = new byte[4 * bi.getWidth() * bi.getHeight()];
            bi.getRaster().getDataElements(0, 0, bi.getWidth(), bi.getHeight(), data);
            int j = 0;
            while (j < data.length) {
                data[j] = r;
                data[j + 1] = g;
                data[j + 2] = b;
                j += 4;
            }
            bi.getRaster().setDataElements(0, 0, bi.getWidth(), bi.getHeight(), data);
            ++i;
        }
    }
}

