/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import com.luugiathuy.apps.downloadmanager.DownloadManager;
import com.luugiathuy.apps.downloadmanager.Downloader;
import hubolauncher.GameVersion;
import hubolauncher.RemoteInfo;
import hubolauncher.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;

public class ZipUpdater {
    static final int MAX_DOWNLOADS = 4;

    public static void main(String[] args) throws Exception {
        System.out.println("Hubolauncher Zip Updater!!");
        if (args.length < 2 || args.length > 3) {
            System.err.println("Got " + args.length + " arguments, expected 2 or 3:");
            System.err.println("1. Local version info file path");
            System.err.println("2. Remote version file URL");
            System.err.println("3. (Optional) Output folder");
            return;
        }
        File versionInfo = new File(args[0]);
        BufferedReader br = null;
        try {
            System.out.println("local=" + args[0]);
            System.out.println("remote=" + args[1]);
            File output = new File(args.length > 2 ? args[2] : ".");
            System.out.println("output=" + output);
            br = new BufferedReader(new FileReader(versionInfo));
            GameVersion installedVersion = GameVersion.read(br, args[0], 0);
            Utils.close(br);
            br = null;
            System.out.println("Current version: " + installedVersion.getHumanReadableVersion());
            RemoteInfo remoteInfo = RemoteInfo.get(args[1], "ZipUpdater", installedVersion);
            System.out.println("Remote version: " + remoteInfo.remoteVersion.getHumanReadableVersion());
            System.out.println("Files to download: " + Arrays.asList(remoteInfo.downloads));
            ArrayList<String> remainingDownloads = new ArrayList<String>();
            int i = 0;
            while (i < remoteInfo.downloads.length) {
                remainingDownloads.add(String.valueOf(remoteInfo.downloadServerURL) + "/" + remoteInfo.downloads[i]);
                ++i;
            }
            DownloadManager man = new DownloadManager();
            ArrayList<Downloader> activeDownloads = man.getDownloadList();
            while (!remainingDownloads.isEmpty() || !activeDownloads.isEmpty()) {
                int i2 = activeDownloads.size() - 1;
                while (i2 >= 0) {
                    Downloader dl = activeDownloads.get(i2);
                    int state = dl.getState();
                    if (state == 2) {
                        System.out.println("Completed: " + dl.getURL());
                        man.removeDownload(i2);
                    } else if (state == 4) {
                        dl.cancel(true);
                        System.err.println("Error: " + dl.getURL());
                        remainingDownloads.add(0, dl.getURL());
                        man.removeDownload(i2);
                    }
                    --i2;
                }
                while (activeDownloads.size() < 4 && !remainingDownloads.isEmpty()) {
                    String url = (String)remainingDownloads.remove(remainingDownloads.size() - 1);
                    System.out.println("Starting: " + url);
                    man.createDownload(DownloadManager.verifyURL(url), output);
                }
                Thread.sleep(100L);
            }
            System.out.println("Updating " + args[0]);
            remoteInfo.remoteVersion.writeInstalledVersion(versionInfo);
        }
        catch (Throwable throwable) {
            Utils.close(br);
            throw throwable;
        }
        Utils.close(br);
    }
}

