/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class Utils {
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;
    public static final byte UNKNOWN = -1;

    public static boolean hasSubdirs(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] subs = dir.listFiles();
            if (subs == null) {
                return false;
            }
            File[] fileArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static InputStream getResourceAsStream(String fname) throws IOException {
        return Utils.getResource(fname).openStream();
    }

    public static URL getResource(String fname) {
        return Utils.getResource(Utils.class, fname);
    }

    public static InputStream getResourceAsStream(Class<?> c, String fname) throws IOException {
        return Utils.getResource(c, fname).openStream();
    }

    public static URL getResource(Class<?> c, String fname) {
        URL url = c.getResource(fname);
        if (url == null) {
            throw new RuntimeException(String.valueOf(fname) + " does not exist (package=\"" + c.getPackage().getName() + "\").");
        }
        return url;
    }

    public static byte isSameFile(File from, File to) {
        if (from == null) {
            return to == null ? (byte)1 : 0;
        }
        if (to == null) {
            return from == null ? (byte)1 : 0;
        }
        try {
            if (from.getCanonicalPath().equals(to.getCanonicalPath())) {
                return 1;
            }
            return 0;
        }
        catch (IOException err) {
            System.err.println("Warning: Failed to compare \"" + from + "\" to \"" + to + "\"");
            err.printStackTrace();
            return -1;
        }
    }

    public static boolean deleteAll(File f, ArrayList<String> errorFiles, String ... exemptions) {
        if (!f.exists()) {
            return true;
        }
        String[] stringArray = exemptions;
        int n = exemptions.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (f.getName().endsWith(e)) {
                System.out.println("Skip: " + f.getName());
                return false;
            }
            ++n2;
        }
        boolean canDeleteMyself = true;
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n3 = fileArray.length;
            n = 0;
            while (n < n3) {
                File ff = fileArray[n];
                canDeleteMyself &= Utils.deleteAll(ff, errorFiles, exemptions);
                ++n;
            }
        }
        if (canDeleteMyself) {
            if (f.delete()) {
                return true;
            }
            if (errorFiles != null) {
                errorFiles.add(f.getName());
            }
            return false;
        }
        return false;
    }

    public static File getDefaultRoot() {
        String OS = System.getProperty("os.name").toUpperCase();
        if (OS.contains("WIN")) {
            return new File(new File(System.getProperty("user.home"), "AppData"), "Roaming");
        }
        return new File(System.getProperty("user.home"));
    }

    public static void close(Closeable strm) {
        if (strm != null) {
            try {
                strm.close();
            }
            catch (IOException err) {
                System.err.println("Warning: Failed to close stream:");
                err.printStackTrace();
            }
        }
    }

    public static String joinArgs(Collection<String> args) {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (String arg : args) {
            if (notFirst) {
                sb.append(' ');
            }
            notFirst = true;
            sb.append('\"');
            int escapes = 0;
            int j = 0;
            while (j < arg.length()) {
                char c = arg.charAt(j);
                if (c == '\\') {
                    ++escapes;
                } else {
                    int k;
                    if (c == '\"') {
                        k = 0;
                        while (k < escapes) {
                            sb.append("\\\\");
                            ++k;
                        }
                        sb.append('\\');
                        sb.append(c);
                    } else {
                        k = 0;
                        while (k < escapes) {
                            sb.append('\\');
                            ++k;
                        }
                        sb.append(c);
                    }
                    escapes = 0;
                }
                ++j;
            }
            int i = 0;
            while (i < escapes) {
                sb.append("\\\\");
                ++i;
            }
            sb.append('\"');
        }
        return sb.toString();
    }

    public static String[] splitArgs(String args) {
        ArrayList<String> r = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int escapes = 0;
        boolean isStr = false;
        int i = 0;
        while (i < args.length()) {
            char c = args.charAt(i);
            if (c == '\\') {
                ++escapes;
            } else {
                int j;
                if (c == '\"') {
                    j = 0;
                    while (j < escapes / 2) {
                        sb.append('\\');
                        ++j;
                    }
                    if (escapes % 2 == 1) {
                        sb.append('\"');
                    } else {
                        isStr = !isStr;
                    }
                } else {
                    j = 0;
                    while (j < escapes) {
                        sb.append('\\');
                        ++j;
                    }
                    if (!isStr && Character.isWhitespace(c)) {
                        if (sb.length() > 0) {
                            r.add(sb.toString());
                            sb.setLength(0);
                        }
                    } else {
                        sb.append(c);
                    }
                }
                escapes = 0;
            }
            ++i;
        }
        if (sb.length() > 0) {
            r.add(sb.toString());
        }
        return r.toArray(new String[r.size()]);
    }
}

