/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import java.text.DecimalFormat;

public class UpdateServerException
extends Exception {
    public UpdateServerException(double code, String extraInfo) {
        super(UpdateServerException.parse(code, extraInfo));
    }

    private static String parse(double code, String extraInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("The update server returned the error code ");
        DecimalFormat fmt = new DecimalFormat("0.#");
        sb.append(fmt.format(code));
        sb.append(":\n");
        String defaultMessage = code == -2.0 ? "An update is being uploaded to the server. Please try again in a few minutes." : (code == -3.0 ? "The update server is undergoing maintenance. Please try again later." : (code == -4.0 ? "Updates for this product are no longer available." : null));
        if (defaultMessage != null) {
            sb.append(defaultMessage);
        } else if (extraInfo.isEmpty()) {
            sb.append("An unknown error with no further information.");
        } else {
            sb.append(extraInfo);
        }
        return sb.toString();
    }
}

