/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import hubolauncher.CommandLineArgs;
import hubolauncher.GameVersion;
import java.awt.Color;

public enum Status {
    NOT_STARTED("Not yet checked.", null),
    CHECKING("Checking for update...", Color.YELLOW),
    CHECK_FAILED("Update check failed.", Color.RED),
    SERVICE_UNAVAILABLE("Service unavailable", Color.RED),
    LAUNCHER_OUTDATED("Hubolauncher outdated", Color.RED),
    NEW_VERSION_AVAILABLE("New version available!", Color.CYAN),
    DOWNLOADING("Downloading update...", Color.YELLOW),
    CONNECTION_LOST("Connection lost. Retry in 3s", Color.RED),
    PAUSED_PENDING("Download Paused...", Color.CYAN),
    PAUSED_VERIFIED("Download Paused.", Color.CYAN),
    NONSPECIFIC_ERROR("Error.", Color.RED),
    PATCHING_ERROR("Patching Error.", Color.RED),
    PATCHING("Patching...", Color.YELLOW),
    LAUNCHING("Launching...", Color.GREEN),
    UP_TO_DATE("Version up to date!", Color.GREEN);

    private String message;
    private Color color;

    private Status(String message, Color color) {
        this.message = message;
        this.color = color;
    }

    public String getMessage() {
        return this.message;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean canPause() {
        return this == DOWNLOADING;
    }

    public boolean canRepatch() {
        return this == PATCHING_ERROR;
    }

    public boolean canResume() {
        return this == CONNECTION_LOST || this == PAUSED_VERIFIED;
    }

    public boolean canUninstall() {
        return this == NOT_STARTED || this == UP_TO_DATE || this == NEW_VERSION_AVAILABLE || this == CHECK_FAILED || this == SERVICE_UNAVAILABLE || this == LAUNCHER_OUTDATED || this == NONSPECIFIC_ERROR || this == PATCHING_ERROR;
    }

    public boolean canLaunch(GameVersion currentVersion) {
        return this != PATCHING && currentVersion != null;
    }

    public boolean canCheck() {
        return this == NOT_STARTED || this == CHECK_FAILED || this == SERVICE_UNAVAILABLE || this == LAUNCHER_OUTDATED || this == NONSPECIFIC_ERROR || this == NEW_VERSION_AVAILABLE || this == UP_TO_DATE;
    }

    public boolean canEditArgs(GameVersion currentVersion, CommandLineArgs args) {
        return this.canLaunch(currentVersion) && args != null;
    }

    public boolean canStart() {
        return this == NEW_VERSION_AVAILABLE;
    }

    public boolean canRestart() {
        return this == DOWNLOADING || this == CONNECTION_LOST || this == PATCHING_ERROR || this == NONSPECIFIC_ERROR || this == PAUSED_VERIFIED;
    }
}

