/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import hubolauncher.CustomTheme;
import hubolauncher.Hubolauncher;
import hubolauncher.Utils;
import hubolauncher.icons.ScalableIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SkinMan {
    public final Hubolauncher hubolauncher;
    CustomTheme theme;
    HashMap<Object, FontUIResource> defaultFonts;
    Color colorize;
    public final ScalableIcon[] zoomIcons;
    public final ScalableIcon[] garbageIcons;
    public final ScalableIcon[] questionIcons;
    public final ScalableIcon[] argsIcons;
    public Image[] checkbox2x;
    Font titleFont;
    Font smallFont;
    Font buttonFont;

    public SkinMan(Hubolauncher hubolauncher) {
        block8: {
            this.colorize = null;
            this.hubolauncher = hubolauncher;
            InputStream fis = null;
            try {
                try {
                    fis = Utils.getResourceAsStream("/bundle/theme.txt");
                    this.theme = new CustomTheme(fis);
                    MetalLookAndFeel.setCurrentTheme(this.theme);
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    this.colorize = this.theme.getControlTextColor();
                }
                catch (Exception e) {
                    System.err.println("Warning: Could not set look and feel.");
                    e.printStackTrace();
                    Utils.close(fis);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Utils.close(fis);
                throw throwable;
            }
            Utils.close(fis);
        }
        try {
            this.checkbox2x = new Image[2];
            this.checkbox2x[0] = ImageIO.read(Utils.getResource(ScalableIcon.class, "checkbox2U.png"));
            this.checkbox2x[1] = ImageIO.read(Utils.getResource(ScalableIcon.class, "checkbox2S.png"));
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        this.zoomIcons = this.loadIcons("zoom");
        this.garbageIcons = this.loadIcons("garbage");
        this.argsIcons = this.loadIcons("args");
        this.questionIcons = this.loadIcons("question");
        this.defaultFonts = new HashMap();
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            this.defaultFonts.put(key, (FontUIResource)value);
        }
        this.updateFonts();
    }

    private ScalableIcon[] loadIcons(String name) {
        ScalableIcon[] r = new ScalableIcon[]{new ScalableIcon(this.hubolauncher.options, name), new ScalableIcon(this.hubolauncher.options, String.valueOf(name) + "_hover"), new ScalableIcon(this.hubolauncher.options, String.valueOf(name) + "_pressed")};
        return r;
    }

    public void updateFonts() {
        int uiScale = this.hubolauncher.options.getUIScale();
        for (Map.Entry<Object, FontUIResource> e : this.defaultFonts.entrySet()) {
            Object key = e.getKey();
            FontUIResource defaultFont = e.getValue();
            if (uiScale == 1) {
                UIManager.put(key, defaultFont);
                continue;
            }
            FontUIResource f = new FontUIResource(defaultFont.getFontName(), defaultFont.getStyle(), defaultFont.getSize() * uiScale);
            UIManager.put(key, new FontUIResource(f));
        }
        int i = 0;
        while (i < this.questionIcons.length) {
            this.questionIcons[i].colorize(this.colorize);
            ++i;
        }
        i = 0;
        while (i < this.argsIcons.length) {
            this.argsIcons[i].colorize(this.colorize);
            ++i;
        }
        this.titleFont = this.theme.getControlTextFont().deriveFont(2, 18 * uiScale);
        this.smallFont = this.theme.getControlTextFont().deriveFont(0, 12 * uiScale);
        this.buttonFont = this.theme.getControlTextFont().deriveFont(1, 14 * uiScale);
    }

    public void dispose() {
        for (Map.Entry<Object, FontUIResource> e : this.defaultFonts.entrySet()) {
            Object key = e.getKey();
            FontUIResource defaultFont = e.getValue();
            UIManager.put(key, defaultFont);
        }
    }

    public JButton createButtonWithIcons(ScalableIcon[] icons) {
        JButton b = new JButton(new ImageIcon(icons[0].image()));
        b.setRolloverIcon(new ImageIcon(icons[1].image()));
        b.setPressedIcon(new ImageIcon(icons[2].image()));
        b.setFont(this.buttonFont);
        b.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        return b;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public JButton createTextButton(String text) {
        JButton r = new JButton(text);
        r.setFont(this.buttonFont);
        return r;
    }

    public Dimension dimension(int w, int h) {
        return new Dimension(w * this.hubolauncher.options.getUIScale(), h * this.hubolauncher.options.getUIScale());
    }

    public JMenuItem createJCheckBoxMenuItem(final Action action, boolean selected) {
        JMenuItem item;
        if (this.hubolauncher.options.getUIScale() == 2) {
            final ImageIcon[] icons = new ImageIcon[]{new ImageIcon(this.checkbox2x[0]), new ImageIcon(this.checkbox2x[1])};
            item = new JMenuItem(action){
                {
                    this.configurePropertiesFromAction(action);
                    PropertyChangeListener actionPropertyChangeListener = this.createActionPropertyChangeListener(action);
                    action.addPropertyChangeListener(actionPropertyChangeListener);
                }
            };
            item.setSelected(selected);
            item.setIcon(icons[selected ? 1 : 0]);
            item.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    item.setIcon(icons[item.isSelected() ? 1 : 0]);
                }
            });
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.setSelected(!item.isSelected());
                    action.actionPerformed(e);
                }
            });
        } else {
            item = new JCheckBoxMenuItem(action);
            item.setAction(action);
            item.setSelected(selected);
        }
        return item;
    }

    public JCheckBox createJCheckBox(String name, boolean selected) {
        JCheckBox box = new JCheckBox(name, selected);
        if (this.hubolauncher.options.getUIScale() == 2) {
            box.setIcon(new ImageIcon(this.checkbox2x[0]));
            box.setSelectedIcon(new ImageIcon(this.checkbox2x[1]));
        }
        return box;
    }
}

