/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import hubolauncher.GameVersion;
import hubolauncher.HubolauncherOutdatedException;
import hubolauncher.UpdateServerException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class RemoteInfo {
    public final GameVersion remoteVersion;
    public final String downloadServerURL;
    public final String[] removes;
    public String[] downloads;

    protected RemoteInfo(String downloadServerURL, GameVersion installedVersion, GameVersion remoteVersion, String[] removes) {
        assert (downloadServerURL != null);
        this.downloadServerURL = downloadServerURL;
        assert (remoteVersion != null);
        this.remoteVersion = remoteVersion;
        assert (removes != null);
        this.removes = removes;
        this.computeDownloadsFor(installedVersion);
    }

    public void computeDownloadsFor(GameVersion installedVersion) {
        Collection<String> tmp = installedVersion == null ? this.remoteVersion.getAllFiles() : installedVersion.getOutdatedFiles(this.remoteVersion);
        this.downloads = tmp.toArray(new String[tmp.size()]);
    }

    public static RemoteInfo get(String updateCheckURL, String gameTitle, GameVersion installedVersion) throws IOException, UpdateServerException, HubolauncherOutdatedException {
        HttpURLConnection conn = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(updateCheckURL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(5000);
            conn.setRequestMethod("GET");
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String requiredVersionString = rd.readLine();
            if (requiredVersionString == null) {
                throw new EOFException("Expected hubolauncher version at line 1 of:\n    " + updateCheckURL);
            }
            if (requiredVersionString.isEmpty()) {
                throw new IOException("Expected hubolauncher version at line 1 of:\n    " + updateCheckURL);
            }
            try {
                double requiredVersion = Double.parseDouble(requiredVersionString);
                if (requiredVersion < 0.0) {
                    String line2;
                    StringBuilder sb = new StringBuilder();
                    while ((line2 = rd.readLine()) != null) {
                        sb.append(line2);
                        sb.append('\n');
                    }
                    throw new UpdateServerException(requiredVersion, sb.toString());
                }
                if (requiredVersion > 2.32) {
                    throw new HubolauncherOutdatedException(gameTitle, requiredVersion, 2.32);
                }
            }
            catch (NumberFormatException e) {
                throw new IOException("Expected hubolauncher version or error code at line 1 of:\n    " + updateCheckURL + "\ngot:\n    " + requiredVersionString);
            }
            String downloadURL = rd.readLine();
            if (downloadURL == null) {
                throw new EOFException("Expected download server URL at second line of:\n" + updateCheckURL);
            }
            if (downloadURL.isEmpty()) {
                throw new IOException("Expected download server URL at second line of:\n" + updateCheckURL);
            }
            GameVersion newVersion = GameVersion.read(rd, String.valueOf('\"') + updateCheckURL + '\"', 2);
            ArrayList<String> tmp = new ArrayList<String>();
            while ((line = rd.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                tmp.add(line);
            }
            RemoteInfo remoteInfo = new RemoteInfo(downloadURL, installedVersion, newVersion, tmp.toArray(new String[tmp.size()]));
            return remoteInfo;
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

