/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import hubolauncher.GameVersion;
import hubolauncher.Hubolauncher;
import hubolauncher.ProgressCallback;
import hubolauncher.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Patcher {
    public final Hubolauncher hubolauncher;
    public final File gameDir;
    public final GameVersion gameVersion;
    public final File[] zipFiles;
    public final File[] filesToRemove;

    public Patcher(Hubolauncher hubolauncher, GameVersion version, String[] zipFileNames, String[] filesToRemove) {
        this.hubolauncher = hubolauncher;
        this.gameDir = hubolauncher.getGameDir();
        this.gameVersion = version;
        this.zipFiles = new File[zipFileNames.length];
        int i = 0;
        while (i < zipFileNames.length) {
            this.zipFiles[i] = new File(this.gameDir, zipFileNames[i]);
            ++i;
        }
        this.filesToRemove = new File[filesToRemove.length];
        i = 0;
        while (i < filesToRemove.length) {
            this.filesToRemove[i] = new File(this.gameDir, filesToRemove[i]);
            ++i;
        }
    }

    public void install(ProgressCallback progress) throws IOException {
        int i = 0;
        while (i < this.zipFiles.length) {
            if (!this.zipFiles[i].exists()) {
                throw new FileNotFoundException("The file " + this.zipFiles[i] + " does not exist!");
            }
            ++i;
        }
        int dlwt = this.hubolauncher.gameInfo.downloadProgressWeight;
        int i2 = 0;
        while (i2 < this.zipFiles.length) {
            int totalPercent = dlwt + i2 * (100 - dlwt) / this.zipFiles.length;
            this.extractZip(this.zipFiles[i2], this.gameDir, String.valueOf(totalPercent) + "% (Install " + (i2 + 1) + "/" + this.zipFiles.length + ")", totalPercent, progress);
            ++i2;
        }
        this.gameVersion.writeInstalledVersion(this.hubolauncher);
        ArrayList<String> errorFiles = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.filesToRemove.length) {
            if (this.filesToRemove[i3].exists()) {
                Utils.deleteAll(this.filesToRemove[i3], errorFiles, new String[0]);
            }
            ++i3;
        }
        if (!errorFiles.isEmpty()) {
            throw new IOException("There was a problem deleting some old files.\nIf the problem persists, try restarting your system and/or deleting them manually.\nThe following files caused the problem:\n" + errorFiles);
        }
        i3 = 0;
        while (i3 < this.zipFiles.length) {
            if (!this.zipFiles[i3].delete()) {
                System.err.println("Warning: Failed to delete zip file \"" + this.zipFiles[i3] + "\" after extracting");
            }
            ++i3;
        }
    }

    public void extractZip(File zipFile, File outputDir, String superText, int superProgress, ProgressCallback progress) throws IOException {
        progress.progress("Extracting " + zipFile.getName() + "...", 0, superText, superProgress);
        outputDir.mkdir();
        long fileSize = zipFile.length();
        FileInputStream fin = null;
        ZipInputStream zipStream = null;
        try {
            try {
                fin = new FileInputStream(zipFile);
                zipStream = new ZipInputStream(fin);
                FileChannel channel = fin.getChannel();
                ZipEntry entry = null;
                while ((entry = zipStream.getNextEntry()) != null) {
                    File destinationPath = new File(outputDir, entry.getName());
                    if (destinationPath.exists()) {
                        destinationPath.delete();
                    }
                    destinationPath.getParentFile().mkdirs();
                    if (entry.isDirectory()) continue;
                    byte[] buffer = new byte[1024];
                    int accumulator = 0;
                    FileOutputStream fos = null;
                    BufferedOutputStream bos = null;
                    try {
                        int b;
                        fos = new FileOutputStream(destinationPath);
                        bos = new BufferedOutputStream(fos, 1024);
                        while ((b = zipStream.read(buffer, 0, 1024)) != -1) {
                            bos.write(buffer, 0, b);
                            if ((accumulator += b) <= 8000) continue;
                            int percentage = (int)(100.0 * (double)channel.position() / (double)fileSize);
                            int kilobytes = (int)(channel.position() / 1000L);
                            progress.progress(String.valueOf(percentage) + "% (" + kilobytes + "/" + fileSize / 1000L + "KiB)", percentage, superText, superProgress);
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.close(bos);
                        Utils.close(fos);
                        throw throwable;
                    }
                    Utils.close(bos);
                    Utils.close(fos);
                }
            }
            catch (IOException ioe) {
                throw new IOException("Patching error: ", ioe);
            }
        }
        catch (Throwable throwable) {
            Utils.close(fin);
            Utils.close(zipStream);
            throw throwable;
        }
        Utils.close(fin);
        Utils.close(zipStream);
    }
}

