/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import bundle.GameInfo;
import hubolauncher.CommandLineArgs;
import hubolauncher.GameVersion;
import hubolauncher.Hubolauncher;
import hubolauncher.PlaintextPreferences;
import hubolauncher.Utils;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class Options {
    private static final String DIRECTORY_KEY = "directory";
    private static final String UI_SCALE_KEY = "uiScale";
    private static final String SUPPRESS_CONNECTIVITY_WARNING_KEY = "suppressConnectivityWarning";
    public final Hubolauncher hubolauncher;
    Preferences p;
    private boolean suppressConnectivityWarning;
    private int uiScale;
    private File directory;
    private LinkedHashSet<String> selectedArgs;

    public Options(Hubolauncher hubolauncher) {
        this.hubolauncher = hubolauncher;
        this.selectedArgs = new LinkedHashSet();
        this.suppressConnectivityWarning = false;
        this.uiScale = this.getDefaultUIScale();
        if (this.prefsExist()) {
            this.suppressConnectivityWarning = this.prefs().getBoolean(SUPPRESS_CONNECTIVITY_WARNING_KEY, this.suppressConnectivityWarning);
            this.uiScale = this.prefs().getInt(UI_SCALE_KEY, this.uiScale);
            this.selectedArgs.addAll(Arrays.asList(Utils.splitArgs(this.prefs().get(this.commandLineArgsKey(), ""))));
        }
        if (hubolauncher.gameInfo.installMode == GameInfo.InstallMode.LOCAL) {
            this.directory = new File(".");
        } else {
            String dirName = this.prefsExist() ? this.prefs().get(DIRECTORY_KEY, null) : null;
            this.directory = dirName != null ? new File(dirName) : hubolauncher.gameInfo.getDefaultDir(hubolauncher.gameInfo.installMode);
        }
    }

    private String commandLineArgsKey() {
        return String.valueOf(this.hubolauncher.gameInfo.gameID) + "_args";
    }

    String localPrefsName() {
        return String.valueOf(this.hubolauncher.gameInfo.gameID) + "_launcher.prefs";
    }

    private boolean prefsExist() {
        block5: {
            try {
                if (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.LOCAL) {
                    return new File(this.localPrefsName()).exists();
                }
                if (Preferences.userRoot().nodeExists(this.hubolauncher.gameInfo.publisherID)) break block5;
                return false;
            }
            catch (BackingStoreException e) {
                return false;
            }
        }
        if (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.SEPARATE) {
            return Preferences.userRoot().node(this.hubolauncher.gameInfo.publisherID).nodeExists(this.hubolauncher.gameInfo.gameID);
        }
        return true;
    }

    private Preferences prefs() {
        if (this.p == null) {
            this.p = this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.LOCAL ? new PlaintextPreferences(null, this.localPrefsName()) : (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.SEPARATE ? Preferences.userRoot().node(this.hubolauncher.gameInfo.publisherID).node(this.hubolauncher.gameInfo.gameID) : Preferences.userRoot().node(this.hubolauncher.gameInfo.publisherID));
        }
        return this.p;
    }

    private int getDefaultUIScale() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getNormalizingTransform().getScaleY() >= 2.0 ? 2 : 1;
    }

    public int getUIScale() {
        return this.uiScale;
    }

    public void setUIScale(int uiScale) {
        this.uiScale = uiScale;
        this.prefs().put(UI_SCALE_KEY, String.valueOf(uiScale));
        this.hubolauncher.frame.setIconImage(this.hubolauncher.bundleIcon.image());
        this.hubolauncher.state.rebuildUI();
    }

    public boolean getSuppressConnectivityWarning() {
        return this.suppressConnectivityWarning;
    }

    public void setSuppressConnectivityWarning(boolean suppressConnectivityWarning) {
        this.suppressConnectivityWarning = suppressConnectivityWarning;
        this.prefs().put(SUPPRESS_CONNECTIVITY_WARNING_KEY, String.valueOf(suppressConnectivityWarning));
    }

    public boolean mustChooseDirectory() {
        if (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.LOCAL) {
            return false;
        }
        if (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.SEPARATE) {
            return this.directory == null || !this.directory.exists() || !new File(this.directory, GameVersion.versionFileName(this.hubolauncher)).exists();
        }
        return this.directory == null || !this.directory.exists() || !Utils.hasSubdirs(this.directory);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        this.prefs().put(DIRECTORY_KEY, directory.getAbsolutePath().replace('\\', '/'));
    }

    public void deletePrefs() throws BackingStoreException {
        this.directory = null;
        this.suppressConnectivityWarning = false;
        this.uiScale = this.getDefaultUIScale();
        if (this.prefsExist()) {
            this.prefs().removeNode();
            this.p = null;
        }
    }

    public void addCommandLineArg(String arg) {
        this.selectedArgs.add(arg);
        this.prefs().put(this.commandLineArgsKey(), Utils.joinArgs(this.selectedArgs));
    }

    public void removeCommandLineArg(String arg) {
        this.selectedArgs.remove(arg);
        this.prefs().put(this.commandLineArgsKey(), Utils.joinArgs(this.selectedArgs));
    }

    public boolean hasCommandLineArg(String arg) {
        return this.selectedArgs.contains(arg);
    }

    public void sanitizeCommandLineArgs(CommandLineArgs commandLineArgs) {
        ArrayList<String> newArgs = new ArrayList<String>();
        int i = 0;
        while (i < commandLineArgs.size()) {
            String arg = commandLineArgs.getArg(i).getArg();
            if (this.hasCommandLineArg(arg)) {
                newArgs.add(arg);
            }
            ++i;
        }
        this.selectedArgs.clear();
        this.selectedArgs.addAll(newArgs);
    }

    public String[] getSelectedCommandLineArgs() {
        return this.selectedArgs.toArray(new String[this.selectedArgs.size()]);
    }

    public void dispose() {
        try {
            if (this.p != null) {
                this.p.flush();
            }
        }
        catch (BackingStoreException err) {
            System.err.println("Warning: Failed to flush preferences: ");
            err.printStackTrace();
        }
    }
}

