/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import bundle.GameInfo;
import hubolauncher.CommandLineArgs;
import hubolauncher.GameVersion;
import hubolauncher.Hubolauncher;
import hubolauncher.HubolauncherOutdatedException;
import hubolauncher.HubolauncherState;
import hubolauncher.SkinMan;
import hubolauncher.SkinnedProgressBarUI;
import hubolauncher.Status;
import hubolauncher.UpdateServerException;
import hubolauncher.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class HubolauncherUI
implements ActionListener {
    private static final String LAUNCH_BUTTON_NAME = "Launch Game";
    private static final String START_BUTTON_NAME = "Update now";
    private final Hubolauncher hubolauncher;
    private volatile boolean isAsking;
    private Image backgroundImage;
    private JPanel rootPanel;
    private JButton urlButton;
    private JPopupMenu urlMenu;
    private JButton uiScaleButton;
    private JMenuItem updateCheckURLItem;
    private JMenuItem updateURLItem;
    private JMenuItem openFolderItem;
    private JMenuItem suppressConnectivityWarningItem;
    private JMenuItem aboutItem;
    private JLabel nameLabel;
    private JLabel currentVersionLabel;
    private JLabel updateVersionLabel;
    private JProgressBar progressBar1;
    private JProgressBar progressBar2;
    private JLabel statusLabel;
    private JButton startRestartButton;
    private JButton pauseResumeButton;
    private JButton updateCheckButton;
    private JButton launchButton;
    private JButton uninstallButton;
    private JButton argsButton;

    public HubolauncherUI(final Hubolauncher hubolauncher) {
        this.hubolauncher = hubolauncher;
        SkinMan skinMan = hubolauncher.skinMan;
        this.backgroundImage = hubolauncher.frame.getIconImage().getScaledInstance(60 * hubolauncher.options.getUIScale(), 60 * hubolauncher.options.getUIScale(), 4);
        this.rootPanel = new JPanel(new GridBagLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int xInset = hubolauncher.options.getUIScale() * hubolauncher.gameInfo.logoInsetX;
                int yInset = hubolauncher.options.getUIScale() * hubolauncher.gameInfo.logoInsetY;
                int w = (int)((float)HubolauncherUI.this.backgroundImage.getWidth(null) * hubolauncher.gameInfo.logoScaleX);
                int h = (int)((float)HubolauncherUI.this.backgroundImage.getHeight(null) * hubolauncher.gameInfo.logoScaleY);
                g.drawImage(HubolauncherUI.this.backgroundImage, this.getWidth() - w - xInset, yInset, w, h, null);
            }
        };
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        int WIDTH = 2;
        Font titleFont = hubolauncher.skinMan.getTitleFont();
        Font smallFont = hubolauncher.skinMan.getSmallFont();
        c.gridheight = 1;
        c.gridwidth = 2;
        c.fill = 1;
        this.nameLabel = new JLabel(String.valueOf(hubolauncher.gameInfo.getGameTitle()) + " ");
        this.nameLabel.setFont(titleFont);
        this.nameLabel.setPreferredSize(hubolauncher.skinMan.dimension(400, 18));
        this.rootPanel.add((Component)this.nameLabel, c);
        ++c.gridy;
        c.fill = 0;
        this.currentVersionLabel = new JLabel(" ");
        this.currentVersionLabel.setFont(smallFont);
        this.rootPanel.add((Component)this.currentVersionLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.fill = 1;
        this.updateCheckButton = skinMan.createTextButton(" ");
        this.updateCheckButton.addActionListener(this);
        this.rootPanel.add((Component)this.updateCheckButton, c);
        ++c.gridy;
        Dimension d = hubolauncher.skinMan.dimension(4, 4);
        c.fill = 1;
        this.rootPanel.add((Component)new Box.Filler(d, d, d), c);
        ++c.gridy;
        this.rootPanel.add((Component)new JSeparator(0), c);
        ++c.gridy;
        this.rootPanel.add((Component)new Box.Filler(d, d, d), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 1;
        this.statusLabel = new JLabel(hubolauncher.state.getStatus().getMessage());
        this.statusLabel.setFont(smallFont);
        this.rootPanel.add((Component)this.statusLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        JPanel mrp = new JPanel();
        this.updateVersionLabel = new JLabel("Latest version: " + hubolauncher.gameInfo.templateVersionString + " ");
        this.updateVersionLabel.setFont(smallFont);
        this.updateVersionLabel.setMinimumSize(this.updateVersionLabel.getPreferredSize());
        this.updateVersionLabel.setPreferredSize(this.updateVersionLabel.getPreferredSize());
        mrp.add((Component)this.updateVersionLabel, c);
        this.urlButton = skinMan.createButtonWithIcons(skinMan.questionIcons);
        this.urlButton.setToolTipText("Additional information.");
        this.urlButton.addActionListener(this);
        this.urlButton.setFocusable(false);
        mrp.add(this.urlButton);
        this.urlMenu = new JPopupMenu();
        this.updateCheckURLItem = new JMenuItem(new AbstractAction("Copy update check URL"){
            private static final long serialVersionUID = 1923914929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection s = new StringSelection(hubolauncher.state.getUpdateCheckURL());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            }
        });
        this.urlMenu.add(this.updateCheckURLItem);
        this.updateCheckURLItem.setToolTipText("<html><body>The update information is retrieved from the following URL: <br>" + hubolauncher.state.getUpdateCheckURL() + "<br>" + "Click this button to copy the URL to the clipboard.</body></html>");
        this.updateURLItem = new JMenuItem(new AbstractAction("Copy download URL(s)"){
            private static final long serialVersionUID = 1923914929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String updateURL = hubolauncher.state.getDownloadServerURL();
                List<String> fnames = hubolauncher.state.getDownloadFileNames();
                if (updateURL != null && fnames != null && !fnames.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < fnames.size()) {
                        if (i != 0) {
                            sb.append("\n");
                        }
                        sb.append(updateURL);
                        sb.append("/");
                        sb.append(fnames.get(i));
                        ++i;
                    }
                    StringSelection s = new StringSelection(sb.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
                }
            }
        });
        this.urlMenu.add(this.updateURLItem);
        this.openFolderItem = new JMenuItem(new AbstractAction(hubolauncher.sandboxDir == null ? "Open game folder" : "Copy game folder"){
            private static final long serialVersionUID = 1923914929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hubolauncher.sandboxDir == null) {
                    try {
                        Desktop.getDesktop().open(hubolauncher.getGameDir());
                    }
                    catch (Exception err) {
                        System.err.println("Failed to open game folder");
                        err.printStackTrace();
                        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                            throw new AssertionError();
                        }
                        ToolTipManager.sharedInstance().setDismissDelay(0);
                        JOptionPane.showMessageDialog(hubolauncher.frame, "Failed to open the game folder!\n\nDetails:\n" + err.getClass().getSimpleName() + ": " + err.getMessage(), "Failed to open folder", 0);
                        HubolauncherUI.this.updateUI();
                        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                    }
                } else {
                    StringSelection s = new StringSelection(hubolauncher.sandboxDir);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
                }
            }
        });
        this.urlMenu.add(this.openFolderItem);
        this.suppressConnectivityWarningItem = hubolauncher.skinMan.createJCheckBoxMenuItem(new AbstractAction("Hide Update Check Errors"){
            private static final long serialVersionUID = 1923914929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                hubolauncher.options.setSuppressConnectivityWarning(HubolauncherUI.this.suppressConnectivityWarningItem.isSelected());
            }
        }, hubolauncher.options.getSuppressConnectivityWarning());
        this.urlMenu.add(this.suppressConnectivityWarningItem);
        this.suppressConnectivityWarningItem.setToolTipText("Whether to suppress the error popup when the update check fails.");
        this.aboutItem = new JMenuItem(new AbstractAction("About Hubolauncher"){
            private static final long serialVersionUID = 1923914929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                ToolTipManager.sharedInstance().setDismissDelay(0);
                int W = 180 * hubolauncher.options.getUIScale();
                JOptionPane.showMessageDialog(hubolauncher.frame, "<html><body><b><font size='7'>Hubolauncher&nbsp;</font></b><p style='width: " + W + "px;'>Version: " + 2.32 + "</p>" + "<br>" + "<p style='width: " + W + "px;'>Authors:<ul style = 'margin: 0 0 0 40;'>" + "<li>The Oddwarg</li>" + "<li>Hubol</li>" + "</ul></p>" + "<br>" + "<p style='width: " + W + "px;'>Hubolauncher is a downloader, installer, updater and launcher for games that run using a Java&nbsp;Virtual&nbsp;Machine.</p>" + "<br>" + "<p style='width: " + W + "px;'>Hubolauncher uses code from Java-Download-Manager, which is Copyright (c) 2011 Luu Gia Thuy, released under the MIT License.</p>" + "</body></html>", "About Hubolauncher", 1);
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            }
        });
        this.urlMenu.add(this.aboutItem);
        this.aboutItem.setToolTipText("Basic information about the launcher.");
        this.rootPanel.add((Component)mrp, c);
        ++c.gridy;
        c.anchor = 17;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        this.progressBar1 = new JProgressBar(0, 100);
        this.progressBar1.setFont(smallFont);
        this.progressBar1.setStringPainted(true);
        this.progressBar1.setUI(new SkinnedProgressBarUI(skinMan.theme));
        this.rootPanel.add((Component)this.progressBar1, c);
        ++c.gridy;
        this.progressBar2 = new JProgressBar(0, 100);
        this.progressBar2.setFont(smallFont);
        this.progressBar2.setStringPainted(true);
        this.progressBar2.setUI(new SkinnedProgressBarUI(skinMan.theme));
        this.rootPanel.add((Component)this.progressBar2, c);
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 1;
        this.startRestartButton = skinMan.createTextButton(" ");
        this.startRestartButton.addActionListener(this);
        this.rootPanel.add((Component)this.startRestartButton, c);
        ++c.gridx;
        this.pauseResumeButton = skinMan.createTextButton(" ");
        this.pauseResumeButton.addActionListener(this);
        this.pauseResumeButton.setToolTipText("Pause or resume the update process!");
        this.rootPanel.add((Component)this.pauseResumeButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        this.rootPanel.add((Component)new Box.Filler(d, d, d), c);
        ++c.gridy;
        this.rootPanel.add((Component)new JSeparator(0), c);
        ++c.gridy;
        this.rootPanel.add((Component)new Box.Filler(d, d, d), c);
        ++c.gridy;
        c.gridwidth = 1;
        this.launchButton = skinMan.createTextButton(" Launching v. " + hubolauncher.gameInfo.templateVersionString + " (Q)");
        this.launchButton.addActionListener(this);
        this.launchButton.setToolTipText("Play " + hubolauncher.gameInfo.getGameTitle() + "!");
        this.launchButton.setMinimumSize(this.launchButton.getPreferredSize());
        this.launchButton.setPreferredSize(this.launchButton.getPreferredSize());
        this.rootPanel.add((Component)this.launchButton, c);
        ++c.gridx;
        JPanel llPanel = new JPanel();
        llPanel.setLayout(new BorderLayout());
        this.argsButton = skinMan.createButtonWithIcons(skinMan.argsIcons);
        this.argsButton.setToolTipText("Change startup options");
        this.argsButton.addActionListener(this);
        this.argsButton.setFocusable(false);
        llPanel.add((Component)this.argsButton, "West");
        JPanel lrPanel = new JPanel();
        lrPanel.setLayout(new BorderLayout());
        this.uiScaleButton = hubolauncher.skinMan.createButtonWithIcons(hubolauncher.skinMan.zoomIcons);
        this.uiScaleButton.setToolTipText("Make the launcher window bigger or smaller.");
        this.uiScaleButton.setFocusable(false);
        this.uiScaleButton.addActionListener(this);
        lrPanel.add((Component)this.uiScaleButton, "West");
        if (hubolauncher.getGameDir().equals(new File("."))) {
            this.uninstallButton = null;
        } else {
            this.uninstallButton = skinMan.createButtonWithIcons(skinMan.garbageIcons);
            this.uninstallButton.addActionListener(this);
            this.uninstallButton.setFocusable(false);
            this.uninstallButton.setToolTipText("Uninstall the game!");
            lrPanel.add((Component)this.uninstallButton, "East");
        }
        llPanel.add((Component)lrPanel, "East");
        this.rootPanel.add((Component)llPanel, c);
        c.gridx = 0;
        ++c.gridy;
        this.updateUI();
    }

    public boolean isShowingDialog() {
        return this.isAsking;
    }

    public JPanel getRootPanel() {
        return this.rootPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isAsking) {
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        HubolauncherState state = this.hubolauncher.state;
        if (e.getSource() == this.updateCheckButton) {
            state.checkForUpdate(true);
        } else if (e.getSource() == this.startRestartButton) {
            HubolauncherState hubolauncherState = state;
            synchronized (hubolauncherState) {
                if (!state.getStatus().canStart() && !state.getStatus().canRestart()) {
                    return;
                }
                if (state.hasUncrashedDownload()) {
                    this.isAsking = true;
                    int r = JOptionPane.showConfirmDialog(this.hubolauncher.frame, "Are you sure you want to reset the download progress?\nPausing/resuming will usually solve the problem.", "Restart download", 0, 3);
                    if (r == 0) {
                        state.startDownload();
                    }
                    this.isAsking = false;
                } else {
                    state.startDownload();
                }
            }
        } else if (e.getSource() == this.pauseResumeButton) {
            state.pauseResumeRetry();
        } else if (e.getSource() == this.launchButton) {
            HubolauncherState hubolauncherState = state;
            synchronized (hubolauncherState) {
                if (state.isDownloading()) {
                    this.isAsking = true;
                    int r = JOptionPane.showConfirmDialog(this.hubolauncher.frame, "Updating has not finished yet. Launching the game now will reset the download progress.\nIs this okay?", "Cancel update", 0, 3);
                    if (r == 0) {
                        state.launchGameNow();
                    }
                    this.isAsking = false;
                } else if (state.getStatus().canLaunch(state.getInstalledVersion())) {
                    state.launchGameNow();
                }
            }
        } else if (e.getSource() == this.argsButton) {
            this.showArgsPopup();
        } else if (e.getSource() == this.uiScaleButton) {
            int r = JOptionPane.showOptionDialog(this.hubolauncher.frame, "Please pick a scale factor for the launcher window.\nThe current value is " + this.hubolauncher.options.getUIScale() + "x.", "Change window size", 1, -1, null, new Object[]{"1x", "2x", "Cancel"}, "Cancel");
            if (r != 2) {
                this.hubolauncher.options.setUIScale(r == 0 ? 1 : 2);
            }
        } else if (e.getSource() == this.uninstallButton) {
            HubolauncherState hubolauncherState = state;
            synchronized (hubolauncherState) {
                if (!state.getStatus().canUninstall()) {
                    return;
                }
                this.isAsking = true;
                int r = JOptionPane.showConfirmDialog(this.hubolauncher.frame, "The game will be uninstalled. This will delete all files, including your save files!\nIs this okay?", "Uninstall game", 0, 2);
                if (r == 0) {
                    state.uninstall();
                }
                this.isAsking = false;
            }
        } else if (e.getSource() == this.urlButton) {
            this.urlMenu.show(this.urlButton, 0, this.urlButton.getHeight());
        } else {
            System.err.println("Unknown event source: " + e.getSource());
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    private void showArgsPopup() {
        JPopupMenu argsMenu = new JPopupMenu();
        CommandLineArgs args = this.hubolauncher.state.getCommandLineArgs();
        int i = 0;
        while (i < args.size()) {
            final CommandLineArgs.CommandLineArg arg = args.getArg(i);
            JMenuItem item = this.hubolauncher.skinMan.createJCheckBoxMenuItem(new AbstractAction(arg.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JMenuItem)e.getSource()).isSelected()) {
                        ((HubolauncherUI)HubolauncherUI.this).hubolauncher.options.addCommandLineArg(arg.getArg());
                    } else {
                        ((HubolauncherUI)HubolauncherUI.this).hubolauncher.options.removeCommandLineArg(arg.getArg());
                    }
                }
            }, this.hubolauncher.options.hasCommandLineArg(arg.getArg()));
            item.setToolTipText(arg.getDescription());
            argsMenu.add(item);
            ++i;
        }
        argsMenu.show(this.argsButton, 0, this.argsButton.getHeight());
    }

    public void updateProgress(Status status, String text1, int percentage1, String text2, int percentage2) {
        this.progressBar1.setEnabled(status != Status.NOT_STARTED);
        this.progressBar1.setString(text1);
        this.progressBar1.setValue(percentage1);
        this.progressBar2.setEnabled(status != Status.NOT_STARTED);
        this.progressBar2.setString(text2);
        this.progressBar2.setValue(percentage2);
    }

    public void updateUI() {
        HubolauncherState state = this.hubolauncher.state;
        GameVersion installedVersion = state.getInstalledVersion();
        Status status = this.hubolauncher.state.getStatus();
        this.urlButton.setEnabled(true);
        this.currentVersionLabel.setText("Current version: " + HubolauncherUI.versionString(installedVersion));
        if (installedVersion == null) {
            this.updateCheckButton.setText("Download game data");
            this.updateCheckButton.setToolTipText("Download necessary game files!");
            this.startRestartButton.setToolTipText("Download necessary game files!");
        } else {
            this.updateCheckButton.setText("Check for update now");
            this.startRestartButton.setToolTipText("Start or restart the update process!");
            this.updateCheckButton.setToolTipText("Connect to the update server to check if there is a newer version available.");
        }
        this.updateCheckButton.setEnabled(status.canCheck());
        if (status.getColor() == null) {
            this.statusLabel.setOpaque(false);
        } else {
            this.statusLabel.setOpaque(true);
            this.statusLabel.setBackground(status.getColor());
        }
        this.statusLabel.setText(status.getMessage());
        String errorInfo = state.getDownloadErrorInfo();
        if (status == Status.CONNECTION_LOST && errorInfo != null) {
            this.statusLabel.setToolTipText("Connection problem: " + errorInfo);
        } else {
            this.statusLabel.setToolTipText(null);
        }
        this.statusLabel.setEnabled(status != Status.NOT_STARTED);
        if (status != Status.PATCHING && status != Status.PATCHING_ERROR && !state.isDownloading()) {
            if (status == Status.LAUNCHING) {
                this.updateProgress(status, "", 100, "100%", 100);
            } else {
                this.updateProgress(status, "", 0, "", 0);
            }
        }
        if (this.hubolauncher.getGameDir().exists()) {
            if (this.hubolauncher.sandboxDir == null) {
                this.openFolderItem.setToolTipText("<html><body>Open the game folder in your system's file explorer:<br>" + this.hubolauncher.getGameDir().getAbsolutePath().toString() + "</body></html>");
            } else {
                this.openFolderItem.setToolTipText("<html><body>Copy the game folder location to the clipboard:<br>" + this.hubolauncher.sandboxDir + "</body></html>");
            }
            this.openFolderItem.setEnabled(true);
        } else {
            this.openFolderItem.setToolTipText("The game folder does not currently exist.");
            this.openFolderItem.setEnabled(false);
        }
        if (state.hasRemoteInfo()) {
            List<String> fnames = state.getDownloadFileNames();
            if (fnames == null || fnames.isEmpty()) {
                this.updateURLItem.setToolTipText("The game is up to date and no files need to be downloaded.");
                this.updateURLItem.setEnabled(false);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body>The update will be downloaded from the following URL");
                if (fnames.size() > 1) {
                    sb.append("s");
                }
                sb.append(":<br>");
                for (String fname : fnames) {
                    sb.append(state.getDownloadServerURL());
                    sb.append("/");
                    sb.append(fname);
                    sb.append("<br>");
                }
                sb.append("Click this button to copy the URL(s) to the clipboard.</body></html>");
                this.updateURLItem.setToolTipText(sb.toString());
                this.updateURLItem.setEnabled(true);
            }
        } else {
            this.updateURLItem.setToolTipText("The update URL is unknown. The launcher must connect to the update server first.");
            this.updateURLItem.setEnabled(false);
        }
        this.updateVersionLabel.setText("Latest version: " + HubolauncherUI.versionString(state.getRemoteVersion()));
        this.updateVersionLabel.setEnabled(status != Status.NOT_STARTED && status != Status.CHECKING);
        this.startRestartButton.setEnabled(status.canStart() || status.canRestart());
        if (status.canRestart()) {
            this.startRestartButton.setText("Restart");
        } else if (installedVersion == null) {
            this.startRestartButton.setText("Start Download");
        } else {
            this.startRestartButton.setText(START_BUTTON_NAME);
        }
        this.pauseResumeButton.setEnabled(status.canRepatch() || status.canPause() || status.canResume());
        if (status.canRepatch()) {
            this.pauseResumeButton.setText("Retry");
        } else if (status.canResume()) {
            this.pauseResumeButton.setText("Resume");
        } else {
            this.pauseResumeButton.setText("Pause");
        }
        this.launchButton.setEnabled(status.canLaunch(installedVersion));
        if (status == Status.LAUNCHING) {
            this.launchButton.setText("Launching v. " + HubolauncherUI.versionString(installedVersion));
        } else {
            this.launchButton.setText(LAUNCH_BUTTON_NAME);
        }
        this.argsButton.setEnabled(status.canEditArgs(state.getInstalledVersion(), state.getCommandLineArgs()));
        this.argsButton.setVisible(status.canEditArgs(state.getInstalledVersion(), state.getCommandLineArgs()));
        if (this.uninstallButton != null) {
            this.uninstallButton.setEnabled(status.canUninstall());
        }
    }

    private static String versionString(GameVersion version) {
        if (version == null) {
            return "N/A";
        }
        return version.getHumanReadableVersion();
    }

    public void updateInfoChanged(boolean alwaysNotifyUser) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        if (this.hubolauncher.state.getInstalledVersion() == null) {
            int r = JOptionPane.showConfirmDialog(this.hubolauncher.frame, String.valueOf(this.hubolauncher.gameInfo.getGameTitle()) + " will now download and install game data!", Status.NEW_VERSION_AVAILABLE.getMessage(), 2, 1);
            if (r == 0) {
                this.hubolauncher.state.startDownload();
            } else {
                this.updateUI();
            }
        } else {
            if (this.hubolauncher.state.getStatus() == Status.UP_TO_DATE) {
                if (alwaysNotifyUser) {
                    JOptionPane.showMessageDialog(this.hubolauncher.frame, String.valueOf(this.hubolauncher.gameInfo.getGameTitle()) + " is up to date!", Status.UP_TO_DATE.getMessage(), 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.hubolauncher.frame, "A new version of " + this.hubolauncher.gameInfo.getGameTitle() + " is available.\n" + "Updates contain important bugfixes! Click the \"" + START_BUTTON_NAME + "\" button\n" + "to automatically install the new version.", Status.NEW_VERSION_AVAILABLE.getMessage(), 1);
            }
            this.updateUI();
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void updateInfoFail(Exception e) {
        boolean canSuppress;
        String message;
        int type;
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        if (e instanceof UpdateServerException) {
            type = 2;
            message = e.getMessage();
            canSuppress = true;
        } else if (e instanceof HubolauncherOutdatedException) {
            type = 0;
            message = e.getMessage();
            canSuppress = true;
        } else if (this.hubolauncher.state.getInstalledVersion() == null) {
            type = 0;
            message = "The launcher could not connect to the update server!\nThe game must connect to the internet to download\ngame data before it can start for the first time.\nPlease make sure you are connected to the internet\nand try again. \n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\nurl = " + this.hubolauncher.state.getUpdateCheckURL();
            canSuppress = false;
        } else {
            type = 2;
            message = "The launcher could not connect to the update server!\nPress the \"Launch Game\" button to start the game without\nperforming the update check. \n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\nurl = " + this.hubolauncher.state.getUpdateCheckURL();
            canSuppress = true;
        }
        if (!canSuppress || !this.hubolauncher.options.getSuppressConnectivityWarning()) {
            JPanel panel = new JPanel(new BorderLayout());
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            String[] split = message.split("\n", -1);
            int i = 0;
            while (i < split.length) {
                if (i != 0) {
                    sb.append("<br>");
                }
                sb.append(split[i]);
                ++i;
            }
            sb.append("</body></html>");
            JLabel label = new JLabel(sb.toString());
            panel.add((Component)label, "Center");
            JCheckBox ignoreButton = null;
            if (canSuppress) {
                ignoreButton = this.hubolauncher.skinMan.createJCheckBox("Do not show this message again", false);
                panel.add((Component)ignoreButton, "South");
            }
            JOptionPane.showMessageDialog(this.hubolauncher.frame, panel, this.hubolauncher.state.getStatus().getMessage(), type);
            if (ignoreButton != null && ignoreButton.isSelected()) {
                this.hubolauncher.options.setSuppressConnectivityWarning(true);
                this.suppressConnectivityWarningItem.setSelected(true);
            }
        }
        this.updateUI();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void downloadFail(Exception e) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        if (e instanceof MalformedURLException) {
            JOptionPane.showMessageDialog(this.hubolauncher.frame, "Download URL is malformed (It's all the fault of " + this.hubolauncher.gameInfo.getPublisherTitle() + ")\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\ndownloadServerURL=" + this.hubolauncher.state.getDownloadServerURL(), Status.NONSPECIFIC_ERROR.getMessage(), 0);
        } else if (e instanceof IllegalStateException) {
            JOptionPane.showMessageDialog(this.hubolauncher.frame, "Unknown error...\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\ndownloadServerURL=" + this.hubolauncher.state.getDownloadServerURL() + "\ndirectory=" + this.hubolauncher.getGameDir(), Status.NONSPECIFIC_ERROR.getMessage(), 0);
        } else if (e instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(this.hubolauncher.frame, "Could not start the download.\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\ndownloadServerURL=" + this.hubolauncher.state.getDownloadServerURL() + "\nupdateDirectory=" + this.hubolauncher.getGameDir(), Status.NONSPECIFIC_ERROR.getMessage(), 0);
        } else {
            JOptionPane.showMessageDialog(this.hubolauncher.frame, "Could not start the download. Please verify that you are connected to the internet.\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\ndownloadServerURL=" + this.hubolauncher.state.getDownloadServerURL() + "\nupdateDirectory=" + this.hubolauncher.getGameDir(), Status.CONNECTION_LOST.getMessage(), 0);
        }
        this.updateUI();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void resumeFail(Exception e) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        JOptionPane.showMessageDialog(this.hubolauncher.frame, "Unexpected Error\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), Status.NONSPECIFIC_ERROR.getMessage(), 0);
        this.updateUI();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void pauseFail(Exception e) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        JOptionPane.showMessageDialog(this.hubolauncher.frame, "Unexpected Error\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), Status.NONSPECIFIC_ERROR.getMessage(), 0);
        this.updateUI();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchComplete() {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        HubolauncherState hubolauncherState = this.hubolauncher.state;
        synchronized (hubolauncherState) {
            this.updateProgress(Status.PATCHING, "", 100, "100%", 100);
            this.isAsking = true;
            int r = JOptionPane.showConfirmDialog(this.hubolauncher.frame, "The latest version has been installed!\nDo you want to launch the game now?", "Launch game", 0, 2);
            if (r == 0) {
                this.hubolauncher.state.launchGameNow();
            } else {
                this.updateUI();
            }
            this.isAsking = false;
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void patchFail(Exception e) {
        this.stackTraceError(Status.PATCHING_ERROR.getMessage(), "Patching failed!", e);
        this.updateUI();
    }

    public void uninstalled(int status) {
        block16: {
            assert (SwingUtilities.isEventDispatchThread());
            ToolTipManager.sharedInstance().setDismissDelay(0);
            File currentDir = this.hubolauncher.options.getDirectory();
            if (status == 0) {
                JOptionPane.showMessageDialog(this.hubolauncher.frame, "The game was completely uninstalled.", "Uninstallation complete.", -1);
            } else if (status == 1) {
                JOptionPane.showMessageDialog(this.hubolauncher.frame, "The game has already been uninstalled.", "Nothing to uninstall.", 1);
            }
            if (this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.SEPARATE || !Utils.hasSubdirs(currentDir)) {
                this.isAsking = true;
                try {
                    int result = this.hubolauncher.gameInfo.installMode == GameInfo.InstallMode.SEPARATE ? 0 : JOptionPane.showConfirmDialog(this.hubolauncher.frame, "You seem to have uninstalled all " + this.hubolauncher.gameInfo.getPublisherTitle() + " games.\n" + "Would you like to change your directory for " + this.hubolauncher.gameInfo.getPublisherTitle() + " games?", "Change directory?", 0, 3);
                    if (result != 0) break block16;
                    currentDir.mkdirs();
                    File newDir = this.hubolauncher.chooseDirectory(currentDir);
                    ArrayList<String> errorFiles = new ArrayList<String>();
                    this.hubolauncher.deleteIfChanged(this.hubolauncher.options.getDirectory(), newDir, true, errorFiles);
                    if (newDir == null) {
                        String backingStoreError = null;
                        try {
                            this.hubolauncher.options.deletePrefs();
                        }
                        catch (BackingStoreException err) {
                            backingStoreError = err.toString();
                        }
                        if (errorFiles.isEmpty() && backingStoreError == null) {
                            JOptionPane.showMessageDialog(this.hubolauncher.frame, "The old directory and preferences has been removed from your machine.\nThe launcher will now close.", "Canceled", 1);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Some traces of the old directory remain.\n\n");
                            if (!errorFiles.isEmpty()) {
                                sb.append("The following files could not be deleted:\n");
                                for (String fname : errorFiles) {
                                    sb.append(fname);
                                    sb.append('\n');
                                }
                                sb.append('\n');
                            }
                            if (backingStoreError != null) {
                                sb.append("The preferences could not be deleted:\n");
                                sb.append(backingStoreError);
                                sb.append("\n\n");
                            }
                            sb.append("The launcher will now close.");
                            JTextArea a = new JTextArea();
                            a.setWrapStyleWord(true);
                            a.setLineWrap(true);
                            a.setEditable(false);
                            a.setText(sb.toString());
                            JScrollPane scp = new JScrollPane(a);
                            scp.setPreferredSize(this.hubolauncher.skinMan.dimension(480, 348));
                            JOptionPane.showMessageDialog(this.hubolauncher.frame, scp, "Cancelled", 1);
                        }
                        this.hubolauncher.dispose();
                        System.exit(0);
                        break block16;
                    }
                    this.hubolauncher.options.setDirectory(newDir);
                    this.hubolauncher.state.directoryChanged();
                    return;
                }
                finally {
                    this.isAsking = false;
                }
            }
        }
        this.updateUI();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void uninstallFail(Exception e) {
        this.longError("Uninstall Error.", "Uninstallation could not remove all files.", e);
    }

    private void longError(String title, String message, Exception e) {
        this.longError(title, String.valueOf(message) + "\n\nDetails:\n" + e.getClass().getSimpleName() + ": " + e.getMessage());
    }

    private void longError(String title, String message) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolTipManager.sharedInstance().setDismissDelay(0);
        JTextArea a = new JTextArea();
        a.setWrapStyleWord(true);
        a.setLineWrap(true);
        a.setEditable(false);
        a.setText(message);
        JScrollPane scp = new JScrollPane(a);
        scp.setPreferredSize(this.hubolauncher.skinMan.dimension(480, 348));
        JOptionPane.showMessageDialog(this.hubolauncher.frame, scp, title, 0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    private void stackTraceError(String title, String message, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            pw.println(message);
            pw.println("\n\nDetails:\n");
            e.printStackTrace(pw);
        }
        catch (Throwable throwable) {
            Utils.close(pw);
            throw throwable;
        }
        Utils.close(pw);
        sw.flush();
        this.longError(title, sw.toString());
    }
}

