/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import com.luugiathuy.apps.downloadmanager.DownloadManager;
import com.luugiathuy.apps.downloadmanager.Downloader;
import hubolauncher.CommandLineArgs;
import hubolauncher.GameVersion;
import hubolauncher.Hubolauncher;
import hubolauncher.HubolauncherOutdatedException;
import hubolauncher.HubolauncherUI;
import hubolauncher.Patcher;
import hubolauncher.ProgressCallback;
import hubolauncher.RemoteInfo;
import hubolauncher.Status;
import hubolauncher.Uninstaller;
import hubolauncher.UpdateServerException;
import hubolauncher.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class HubolauncherState {
    public final Hubolauncher hubolauncher;
    private HubolauncherUI ui;
    private final DownloadManager downloadManager;
    private Downloader currentDownload;
    private int currentDownloadID;
    private Status status;
    private long statusNo;
    private Timer progressTimer = null;
    private Timer retryTimer = null;
    private CommandLineArgs commandLineArgs;
    private GameVersion installedVersion;
    private final String updateCheckURL;
    private RemoteInfo remoteInfo = null;
    private final Runnable updateUIAction = new Runnable(){

        @Override
        public void run() {
            HubolauncherState.this.ui.updateUI();
        }
    };

    public HubolauncherState(Hubolauncher hubolauncher) {
        this.hubolauncher = hubolauncher;
        this.downloadManager = new DownloadManager();
        this.currentDownload = null;
        this.currentDownloadID = -1;
        this.status = Status.NOT_STARTED;
        this.statusNo = 0L;
        this.commandLineArgs = CommandLineArgs.readCommandLineArgs(hubolauncher);
        this.installedVersion = GameVersion.readInstalledVersion(hubolauncher);
        this.updateCheckURL = String.valueOf(hubolauncher.gameInfo.updateCheckURL) + "/" + hubolauncher.gameInfo.gameID + ".txt";
    }

    public void rebuildUI() {
        assert (SwingUtilities.isEventDispatchThread());
        boolean mustRedisplay = false;
        if (this.ui != null) {
            this.hubolauncher.frame.remove(this.ui.getRootPanel());
            this.hubolauncher.frame.dispose();
            mustRedisplay = true;
        }
        this.hubolauncher.skinMan.updateFonts();
        this.ui = new HubolauncherUI(this.hubolauncher);
        this.hubolauncher.frame.add(this.ui.getRootPanel());
        this.hubolauncher.frame.pack();
        this.hubolauncher.frame.setResizable(false);
        this.hubolauncher.frame.setLocationRelativeTo(null);
        if (mustRedisplay) {
            this.hubolauncher.frame.setVisible(true);
            this.hubolauncher.frame.repaint();
        }
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public String getUpdateCheckURL() {
        return this.updateCheckURL;
    }

    public synchronized GameVersion getInstalledVersion() {
        return this.installedVersion;
    }

    public synchronized CommandLineArgs getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public synchronized String getDownloadServerURL() {
        return this.remoteInfo == null ? null : this.remoteInfo.downloadServerURL;
    }

    public synchronized boolean hasRemoteInfo() {
        return this.remoteInfo != null;
    }

    public synchronized List<String> getDownloadFileNames() {
        return this.remoteInfo == null ? null : Collections.unmodifiableList(Arrays.asList(this.remoteInfo.downloads));
    }

    public synchronized GameVersion getRemoteVersion() {
        return this.remoteInfo == null ? null : this.remoteInfo.remoteVersion;
    }

    public synchronized String getDownloadErrorInfo() {
        if (this.currentDownload == null) {
            return null;
        }
        return this.currentDownload.getErrorInfo();
    }

    public synchronized void checkForUpdate(final boolean alwaysNotifyUser) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.status.canCheck()) {
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.status = Status.CHECKING;
        ++this.statusNo;
        final long myStatusNo = this.statusNo;
        this.ui.updateUI();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final RemoteInfo newInfo = RemoteInfo.get(HubolauncherState.this.updateCheckURL, HubolauncherState.this.hubolauncher.gameInfo.getGameTitle(), HubolauncherState.this.installedVersion);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HubolauncherState hubolauncherState = HubolauncherState.this;
                            synchronized (hubolauncherState) {
                                if (HubolauncherState.this.status != Status.CHECKING || HubolauncherState.this.statusNo != myStatusNo) {
                                    return;
                                }
                                System.out.println("Remote version: ");
                                System.out.println(newInfo.remoteVersion);
                                System.out.println();
                                HubolauncherState.this.remoteInfo = newInfo;
                                HubolauncherState.this.currentDownload = null;
                                HubolauncherState.this.currentDownloadID = -1;
                                HubolauncherState.this.status = ((HubolauncherState)(this).HubolauncherState.this).remoteInfo.downloads.length == 0 ? Status.UP_TO_DATE : Status.NEW_VERSION_AVAILABLE;
                                HubolauncherState.this.ui.updateInfoChanged(alwaysNotifyUser);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    HubolauncherState hubolauncherState = HubolauncherState.this;
                    synchronized (hubolauncherState) {
                        if (HubolauncherState.this.status != Status.CHECKING || HubolauncherState.this.statusNo != myStatusNo) {
                            return;
                        }
                    }
                    e.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HubolauncherState hubolauncherState = HubolauncherState.this;
                            synchronized (hubolauncherState) {
                                if (HubolauncherState.this.status != Status.CHECKING || HubolauncherState.this.statusNo != myStatusNo) {
                                    return;
                                }
                                HubolauncherState.this.remoteInfo = null;
                                HubolauncherState.this.currentDownload = null;
                                HubolauncherState.this.currentDownloadID = -1;
                                if (e instanceof UpdateServerException) {
                                    HubolauncherState.this.status = Status.SERVICE_UNAVAILABLE;
                                } else if (e instanceof HubolauncherOutdatedException) {
                                    HubolauncherState.this.status = Status.LAUNCHER_OUTDATED;
                                } else {
                                    HubolauncherState.this.status = Status.CHECK_FAILED;
                                }
                                HubolauncherState.this.ui.updateInfoFail(e);
                            }
                        }
                    });
                }
            }
        };
        t.start();
    }

    public synchronized void startDownload() {
        assert (this.status.canStart() || this.status.canRestart());
        assert (SwingUtilities.isEventDispatchThread());
        this.deleteProgressTimer();
        this.deleteRetryTimer();
        System.out.println("INFO: Download starting from " + this.remoteInfo.downloadServerURL);
        if (this.currentDownload != null) {
            this.cancelDownload();
        }
        File gameDir = this.hubolauncher.getGameDir();
        gameDir.mkdirs();
        if (!gameDir.isDirectory()) {
            this.status = Status.NONSPECIFIC_ERROR;
            this.ui.downloadFail(new FileNotFoundException("Failed to create game directory!"));
            return;
        }
        try {
            Timer newTimer;
            this.nextDownload();
            this.progressTimer = newTimer = new Timer("Progress Timer", true);
            this.progressTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HubolauncherState hubolauncherState = HubolauncherState.this;
                    synchronized (hubolauncherState) {
                        if (HubolauncherState.this.progressTimer != newTimer) {
                            return;
                        }
                        if (HubolauncherState.this.currentDownload.getState() == 1 && HubolauncherState.this.status != Status.PAUSED_VERIFIED && HubolauncherState.this.currentDownload.isHalted() && !HubolauncherState.this.ui.isShowingDialog()) {
                            HubolauncherState.this.status = Status.PAUSED_VERIFIED;
                            SwingUtilities.invokeLater(HubolauncherState.this.updateUIAction);
                        } else if (HubolauncherState.this.currentDownload.getState() == 4 && HubolauncherState.this.status != Status.CONNECTION_LOST && HubolauncherState.this.currentDownload.isHalted() && !HubolauncherState.this.ui.isShowingDialog()) {
                            if (HubolauncherState.this.status == Status.PAUSED_PENDING) {
                                HubolauncherState.this.status = Status.PAUSED_VERIFIED;
                                SwingUtilities.invokeLater(HubolauncherState.this.updateUIAction);
                            } else if (HubolauncherState.this.status != Status.PAUSED_VERIFIED) {
                                HubolauncherState.this.status = Status.CONNECTION_LOST;
                                HubolauncherState.this.deleteRetryTimer();
                                final Timer newTimer2 = new Timer("Retry Timer", true);
                                HubolauncherState.this.retryTimer = newTimer2;
                                HubolauncherState.this.retryTimer.schedule(new TimerTask(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        HubolauncherState hubolauncherState = HubolauncherState.this;
                                        synchronized (hubolauncherState) {
                                            if (HubolauncherState.this.retryTimer != newTimer2) {
                                                return;
                                            }
                                            if (HubolauncherState.this.status.canResume()) {
                                                HubolauncherState.this.resume();
                                            }
                                        }
                                    }
                                }, 3000L);
                                SwingUtilities.invokeLater(HubolauncherState.this.updateUIAction);
                            }
                        } else if (HubolauncherState.this.currentDownload.getState() == 2 && HubolauncherState.this.currentDownload.isHalted() && !HubolauncherState.this.ui.isShowingDialog()) {
                            if (HubolauncherState.this.status != Status.DOWNLOADING) {
                                if (HubolauncherState.this.status == Status.PAUSED_PENDING) {
                                    HubolauncherState.this.status = Status.PAUSED_VERIFIED;
                                    SwingUtilities.invokeLater(HubolauncherState.this.updateUIAction);
                                }
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            HubolauncherState.this.nextTask();
                                        }
                                        catch (IOException e) {
                                            HubolauncherState hubolauncherState = HubolauncherState.this;
                                            synchronized (hubolauncherState) {
                                                HubolauncherState.this.status = Status.NONSPECIFIC_ERROR;
                                            }
                                            e.printStackTrace();
                                            HubolauncherState.this.ui.downloadFail(e);
                                        }
                                    }
                                });
                            }
                        } else {
                            String text;
                            int percentage;
                            if (HubolauncherState.this.currentDownload == null) {
                                percentage = 0;
                                text = "";
                            } else if (HubolauncherState.this.currentDownload.getFileSize() <= 0) {
                                percentage = 0;
                                text = "Pending...";
                            } else {
                                percentage = (int)HubolauncherState.this.currentDownload.getProgress();
                                int kilobytes = (int)((float)HubolauncherState.this.currentDownload.getFileSize() * HubolauncherState.this.currentDownload.getProgress() / 100.0f / 1024.0f);
                                text = String.valueOf(percentage) + "% (" + kilobytes + "/" + HubolauncherState.this.currentDownload.getFileSize() / 1000 + "KiB)";
                            }
                            final Status currentStatus = HubolauncherState.this.status;
                            final int superProgress = HubolauncherState.this.currentDownloadID * HubolauncherState.this.hubolauncher.gameInfo.downloadProgressWeight / ((HubolauncherState)HubolauncherState.this).remoteInfo.downloads.length;
                            final String superText = String.valueOf(superProgress) + "% (Download " + (HubolauncherState.this.currentDownloadID + 1) + "/" + ((HubolauncherState)HubolauncherState.this).remoteInfo.downloads.length + ")";
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HubolauncherState.this.ui.updateProgress(currentStatus, text, percentage, superText, superProgress);
                                }
                            });
                        }
                    }
                }
            }, 0L, 100L);
            this.status = Status.DOWNLOADING;
            this.ui.updateUI();
        }
        catch (Exception e) {
            this.status = Status.NONSPECIFIC_ERROR;
            e.printStackTrace();
            this.ui.downloadFail(e);
        }
    }

    private synchronized void nextDownload() throws MalformedURLException {
        String nextFile = this.remoteInfo.downloads[this.currentDownloadID + 1];
        String urlStr = String.valueOf(this.remoteInfo.downloadServerURL) + "/" + nextFile;
        URL url = DownloadManager.verifyURL(urlStr);
        if (url == null) {
            throw new MalformedURLException(urlStr);
        }
        this.currentDownload = this.downloadManager.createDownload(url, this.hubolauncher.getGameDir());
        ++this.currentDownloadID;
    }

    private synchronized void nextTask() throws MalformedURLException {
        if (this.currentDownloadID < this.remoteInfo.downloads.length - 1) {
            this.nextDownload();
            this.ui.updateUI();
        } else {
            this.currentDownload = null;
            this.currentDownloadID = -1;
            this.applyPatch();
        }
    }

    private synchronized void cancelDownload() {
        try {
            this.currentDownload.cancel(true);
        }
        catch (Exception e) {
            System.err.println("Warning: Cancel operation caused an exception:");
            e.printStackTrace();
        }
        this.currentDownload = null;
        this.currentDownloadID = -1;
    }

    public synchronized boolean hasUncrashedDownload() {
        return this.currentDownload != null && this.status != Status.NONSPECIFIC_ERROR;
    }

    public synchronized boolean isDownloading() {
        return this.currentDownload != null && this.status != Status.UP_TO_DATE && this.status != Status.LAUNCHING;
    }

    public synchronized void pause() {
        assert (this.status.canPause());
        if (!this.status.canPause()) {
            return;
        }
        try {
            this.status = Status.PAUSED_PENDING;
            this.currentDownload.pause();
            this.ui.updateUI();
        }
        catch (IllegalArgumentException e) {
            this.status = Status.NONSPECIFIC_ERROR;
            e.printStackTrace();
            this.ui.pauseFail(e);
        }
    }

    public synchronized void resume() {
        assert (this.status.canResume());
        if (!this.status.canResume()) {
            return;
        }
        try {
            this.deleteRetryTimer();
            this.status = Status.DOWNLOADING;
            this.currentDownload.resume();
            this.ui.updateUI();
        }
        catch (IllegalArgumentException e) {
            this.status = Status.NONSPECIFIC_ERROR;
            e.printStackTrace();
            this.ui.resumeFail(e);
        }
    }

    public synchronized void applyPatch() {
        this.deleteRetryTimer();
        this.deleteProgressTimer();
        final Patcher patcher = new Patcher(this.hubolauncher, this.remoteInfo.remoteVersion, this.remoteInfo.downloads, this.remoteInfo.removes);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    patcher.install(new ProgressCallback(){

                        @Override
                        public void progress(final String text1, final int percentage1, final String text2, final int percentage2) {
                            final Status status = HubolauncherState.this.getStatus();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HubolauncherState.this.ui.updateProgress(status, text1, percentage1, text2, percentage2);
                                }
                            });
                        }
                    });
                    HubolauncherState hubolauncherState = HubolauncherState.this;
                    synchronized (hubolauncherState) {
                        HubolauncherState.this.setInstalledVersion(((HubolauncherState)HubolauncherState.this).remoteInfo.remoteVersion);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HubolauncherState.this.ui.patchComplete();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    HubolauncherState hubolauncherState = HubolauncherState.this;
                    synchronized (hubolauncherState) {
                        HubolauncherState.this.status = Status.PATCHING_ERROR;
                    }
                    e.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HubolauncherState.this.ui.patchFail(e);
                        }
                    });
                }
            }
        };
        this.status = Status.PATCHING;
        this.ui.updateUI();
        t.start();
    }

    public synchronized void uninstall() {
        assert (this.status.canUninstall());
        System.out.println("INFO: Uninstalling game");
        try {
            Uninstaller uninstaller = new Uninstaller(this.hubolauncher);
            int status = uninstaller.uninstall();
            this.setInstalledVersion(null);
            this.ui.uninstalled(status);
        }
        catch (IOException e) {
            this.ui.uninstallFail(e);
        }
    }

    public synchronized void pauseResumeRetry() {
        if (this.status.canRepatch()) {
            this.applyPatch();
        } else if (this.status.canResume()) {
            this.resume();
        } else if (this.status.canPause()) {
            this.pause();
        }
    }

    public synchronized void launchGameNow() {
        String[] jvmArgs;
        String[] allArgs;
        block8: {
            assert (this.status.canLaunch(this.installedVersion));
            if (!this.status.canLaunch(this.installedVersion)) {
                return;
            }
            this.deleteProgressTimer();
            if (this.currentDownload != null) {
                this.cancelDownload();
            }
            System.out.println("INFO: Starting game");
            this.status = Status.LAUNCHING;
            this.hubolauncher.dispose();
            if (this.commandLineArgs != null) {
                this.hubolauncher.options.sanitizeCommandLineArgs(this.commandLineArgs);
            }
            String[] userArgs = this.hubolauncher.options.getSelectedCommandLineArgs();
            allArgs = new String[userArgs.length + this.hubolauncher.args.length];
            System.arraycopy(userArgs, 0, allArgs, 0, userArgs.length);
            System.arraycopy(this.hubolauncher.args, 0, allArgs, userArgs.length, this.hubolauncher.args.length);
            String uiScaleArgPrefix = "-Dhubol.ui.scale=";
            String uiScaleArg = String.valueOf(uiScaleArgPrefix) + String.valueOf(this.hubolauncher.options.getUIScale());
            if (this.hubolauncher.gameInfo.jvmArgs == null) {
                jvmArgs = new String[]{uiScaleArg};
            } else {
                String[] stringArray = jvmArgs = Utils.splitArgs(this.hubolauncher.gameInfo.jvmArgs);
                int n = jvmArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (!arg.startsWith(uiScaleArgPrefix)) {
                        ++n2;
                        continue;
                    }
                    break block8;
                }
                jvmArgs = Arrays.copyOf(jvmArgs, jvmArgs.length + 1);
                jvmArgs[jvmArgs.length - 1] = uiScaleArg;
            }
        }
        this.hubolauncher.gameInfo.launcherMode.launchGame(this.hubolauncher.getGameDir(), this.hubolauncher.gameInfo.getJarFilePath(), allArgs, jvmArgs);
    }

    private synchronized void deleteProgressTimer() {
        if (this.progressTimer != null) {
            System.out.println("INFO: Destroying progress timer");
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
    }

    private synchronized void deleteRetryTimer() {
        if (this.retryTimer != null) {
            System.out.println("INFO: Destroying retry timer");
            this.retryTimer.cancel();
            this.retryTimer = null;
        }
    }

    public synchronized void dispose() {
        this.deleteProgressTimer();
        this.deleteRetryTimer();
        if (this.currentDownload != null) {
            this.cancelDownload();
        }
    }

    public void directoryChanged() {
        this.setInstalledVersion(GameVersion.readInstalledVersion(this.hubolauncher));
        SwingUtilities.invokeLater(this.updateUIAction);
    }

    private synchronized void setInstalledVersion(GameVersion newVersion) {
        this.commandLineArgs = CommandLineArgs.readCommandLineArgs(this.hubolauncher);
        this.installedVersion = newVersion;
        this.remoteInfo.computeDownloadsFor(this.installedVersion);
        this.currentDownload = null;
        this.currentDownloadID = -1;
        this.status = this.remoteInfo == null ? Status.NOT_STARTED : (this.remoteInfo.downloads.length > 0 ? Status.NEW_VERSION_AVAILABLE : Status.UP_TO_DATE);
    }
}

