/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import bundle.ConfigFile;
import bundle.GameInfo;
import hubolauncher.HubolauncherState;
import hubolauncher.Options;
import hubolauncher.SkinMan;
import hubolauncher.Utils;
import hubolauncher.icons.ScalableIcon;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class Hubolauncher {
    public static final double HUBOLAUNCHER_VERSION = 2.32;
    public static final int COUNTDOWN_SECS = 3;
    public static final int RETRY_TIME_SECS = 3;
    public final GameInfo gameInfo;
    public final SkinMan skinMan;
    public final Options options;
    public final ScalableIcon bundleIcon;
    public final JFrame frame;
    public final String sandboxDir;
    public final HubolauncherState state;
    public final String[] args;

    public static void main(final String[] args) {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Hubolauncher(args);
            }
        });
    }

    public Hubolauncher(String[] args) {
        System.out.println(this.getClass().getSimpleName());
        this.args = args;
        System.out.println("args=" + Arrays.toString(args));
        String tmp = System.getProperty("hubolauncher.sandbox.dir");
        this.sandboxDir = tmp == null ? tmp : tmp.replace("~", System.getProperty("user.home"));
        System.out.println("sandboxDir=" + this.sandboxDir);
        System.out.println();
        this.gameInfo = new GameInfo();
        System.out.println(this.gameInfo);
        System.out.println();
        this.options = new Options(this);
        this.skinMan = new SkinMan(this);
        this.bundleIcon = new ScalableIcon(this.options, ConfigFile.class, "icon");
        this.frame = new JFrame(String.valueOf(Hubolauncher.class.getSimpleName()) + ": " + this.gameInfo.getGameTitle());
        this.frame.setResizable(false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Hubolauncher.this.dispose();
                System.exit(0);
            }
        });
        this.frame.setIconImage(this.bundleIcon.image());
        try {
            if (this.options.mustChooseDirectory()) {
                this.chooseDirectory();
            }
        }
        catch (IllegalStateException err) {
            assert (SwingUtilities.isEventDispatchThread());
            ToolTipManager.sharedInstance().setDismissDelay(0);
            JOptionPane.showMessageDialog(this.frame, String.valueOf(err.getMessage()) + "\nLauncher will now close.", "Cancelled", 1);
            System.exit(0);
        }
        this.state = new HubolauncherState(this);
        System.out.println("Installed version: ");
        System.out.println(this.state.getInstalledVersion());
        System.out.println();
        this.state.rebuildUI();
        this.state.checkForUpdate(false);
        this.frame.setVisible(true);
    }

    public void dispose() {
        this.options.dispose();
        this.state.dispose();
        this.frame.dispose();
        this.skinMan.dispose();
    }

    private void chooseDirectory() {
        int status;
        File file;
        assert (SwingUtilities.isEventDispatchThread());
        File defaultDirectory = this.options.getDirectory();
        boolean mustDeleteIfChanged = defaultDirectory.mkdirs();
        if (!defaultDirectory.isDirectory()) {
            if (mustDeleteIfChanged) {
                throw new IllegalStateException("The directory " + defaultDirectory.getName() + " was created, but does not exist!");
            }
            if (defaultDirectory.exists()) {
                System.out.println("INFO: " + defaultDirectory + " already exists but is not a directory");
            } else {
                System.out.println("INFO: Failed to create " + defaultDirectory);
            }
            defaultDirectory = null;
        }
        if ((file = (status = defaultDirectory != null ? JOptionPane.showOptionDialog(this.frame, "An installation directory is needed.\nA default can be selected for you.", "Setup", 1, 3, null, new Object[]{"OK", "Let me choose", "Cancel"}, "OK") : 1) == 0 ? defaultDirectory : (status == 1 ? this.chooseDirectory(defaultDirectory) : null)) != null) {
            if (mustDeleteIfChanged) {
                this.deleteIfChanged(defaultDirectory, file, false, null);
            }
            file.mkdirs();
            if (!file.isDirectory()) {
                if (file.exists()) {
                    throw new IllegalStateException("The selected file \"" + file.getName() + "\" is not a directory.");
                }
                throw new IllegalStateException("Failed to create the directory \"" + file.getName() + "\"!");
            }
            System.out.println("User selected directory: " + file);
            this.options.setDirectory(file);
            return;
        }
        throw new IllegalStateException("Cannot run the game without an installation directory.");
    }

    public void deleteIfChanged(File from, File to, boolean recursive, ArrayList<String> errorFiles) {
        if (Utils.isSameFile(from, to) == 0) {
            if (recursive) {
                Utils.deleteAll(from, errorFiles, new String[0]);
            } else if (!from.delete()) {
                errorFiles.add(from.getName());
            }
        }
    }

    public File chooseDirectory(File defaultDirectory) {
        JFileChooser fc = new JFileChooser(defaultDirectory);
        fc.setFileSelectionMode(1);
        fc.setApproveButtonText("Select");
        if (this.gameInfo.installMode == GameInfo.InstallMode.PUBLISHER) {
            fc.setDialogTitle("Select a directory for " + this.gameInfo.getPublisherTitle() + " games");
        } else {
            fc.setDialogTitle("Select a directory for " + this.gameInfo.getGameTitle());
        }
        fc.setToolTipText("Select");
        int result = fc.showDialog(this.frame, null);
        if (result == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public File getGameDir() {
        if (this.gameInfo.installMode == GameInfo.InstallMode.PUBLISHER) {
            return new File(this.options.getDirectory(), this.gameInfo.gameID);
        }
        return this.options.getDirectory();
    }
}

