/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import hubolauncher.Hubolauncher;
import hubolauncher.Utils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GameVersion {
    private String humanReadableVersion = null;
    private LinkedHashMap<String, Double> versionByFileName = new LinkedHashMap();

    public String getHumanReadableVersion() {
        return this.humanReadableVersion;
    }

    public Set<String> getAllFiles() {
        return this.versionByFileName.keySet();
    }

    public List<String> getOutdatedFiles(GameVersion newVersion) {
        ArrayList<String> r = new ArrayList<String>();
        for (Map.Entry<String, Double> e : newVersion.versionByFileName.entrySet()) {
            Double current = this.versionByFileName.get(e.getKey());
            if (current != null && !(current < e.getValue())) continue;
            r.add(e.getKey());
        }
        return r;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        return sw.toString();
    }

    static String versionFileName(Hubolauncher hubolauncher) {
        return String.valueOf(hubolauncher.gameInfo.gameID) + "_version.info";
    }

    public void writeInstalledVersion(Hubolauncher hubolauncher) {
        this.writeInstalledVersion(new File(hubolauncher.getGameDir(), GameVersion.versionFileName(hubolauncher)));
    }

    public void writeInstalledVersion(File ver) {
        block5: {
            FileWriter w = null;
            try {
                try {
                    w = new FileWriter(ver);
                    this.write(w);
                }
                catch (IOException err) {
                    System.err.println("Warning: Failed to write installed game version: " + ver);
                    err.printStackTrace();
                    Utils.close(w);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Utils.close(w);
                throw throwable;
            }
            Utils.close(w);
        }
    }

    private void write(Writer w) {
        PrintWriter pw = new PrintWriter(w);
        pw.print(this.humanReadableVersion);
        for (Map.Entry<String, Double> e : this.versionByFileName.entrySet()) {
            pw.println();
            pw.println(e.getKey());
            pw.print(e.getValue());
        }
    }

    public static GameVersion readInstalledVersion(Hubolauncher hubolauncher) {
        GameVersion gameVersion;
        File gameDir = hubolauncher.getGameDir();
        File ver = new File(gameDir, GameVersion.versionFileName(hubolauncher));
        if (!ver.exists()) {
            return null;
        }
        File jar = new File(gameDir, hubolauncher.gameInfo.getJarFilePath());
        if (!jar.exists()) {
            System.err.println("Warning: A game version file was found, but the associated jarfile \"" + jar + "\" does not exist.");
            return null;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ver));
            gameVersion = GameVersion.read(br, String.valueOf('\"') + ver.getPath() + '\"', 0);
        }
        catch (IOException err) {
            try {
                System.err.println("Warning: Failed to parse game version file \"" + ver + "\":");
                err.printStackTrace();
            }
            catch (Throwable throwable) {
                Utils.close(br);
                throw throwable;
            }
            Utils.close(br);
            return null;
        }
        Utils.close(br);
        return gameVersion;
    }

    public static GameVersion read(BufferedReader br, String streamName, int lineOffset) throws IOException {
        GameVersion g = new GameVersion();
        String line = br.readLine();
        if (line == null || line.isEmpty()) {
            throw new EOFException("Expected human readable version at line " + (1 + lineOffset) + " of " + streamName + "!");
        }
        g.humanReadableVersion = line;
        String versionString = null;
        while ((line = br.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (line.startsWith("$")) {
                return g;
            }
            try {
                versionString = br.readLine();
                if (versionString == null || versionString.isEmpty()) {
                    throw new EOFException("Expected version number after \"" + line + "\" in " + streamName + "!");
                }
                Double version = Double.parseDouble(versionString);
                g.versionByFileName.put(line, version);
            }
            catch (NumberFormatException err) {
                throw new IOException("Expected version number after \"" + line + "\" in " + streamName + ", got: \"" + versionString + "\"", err);
            }
        }
        return g;
    }
}

