/*
 * Decompiled with CFR 0.152.
 */
package hubolauncher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class CustomTheme
extends DefaultMetalTheme {
    private String szThemeName = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;
    private FontUIResource windowTitleFont;
    private FontUIResource controlFont;

    public CustomTheme(InputStream is) {
        this.defaultColors();
        this.defaultFonts();
        this.loadProperties(is);
    }

    private void defaultFonts() {
        this.windowTitleFont = super.getWindowTitleFont();
        this.controlFont = super.getControlTextFont();
    }

    private void defaultColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    private void loadProperties(InputStream is) {
        Properties prop = new Properties();
        try {
            prop.load(is);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        String szTemp = prop.getProperty("name");
        if (szTemp != null) {
            this.szThemeName = szTemp;
        }
        if ((szTemp = prop.getProperty("primary1")) != null) {
            this.primary1 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("primary2")) != null) {
            this.primary2 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("primary3")) != null) {
            this.primary3 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("secondary1")) != null) {
            this.secondary1 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("secondary2")) != null) {
            this.secondary2 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("secondary3")) != null) {
            this.secondary3 = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("black")) != null) {
            this.black = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("white")) != null) {
            this.white = this.parseColor(szTemp);
        }
        if ((szTemp = prop.getProperty("titlefont")) != null) {
            this.windowTitleFont = this.parseFont(szTemp);
        }
        if ((szTemp = prop.getProperty("controlfont")) != null) {
            this.controlFont = this.parseFont(szTemp);
        }
    }

    private ColorUIResource parseColor(String color) {
        int b = 0;
        int g = 0;
        int r = 0;
        try {
            StringTokenizer stok = new StringTokenizer(color, ",");
            r = Integer.parseInt(stok.nextToken());
            g = Integer.parseInt(stok.nextToken());
            b = Integer.parseInt(stok.nextToken());
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Couldn't parse color :" + color);
        }
        return new ColorUIResource(r, g, b);
    }

    private FontUIResource parseFont(String font) {
        FontUIResource r;
        String szNames = "Dialog";
        int iSize = 12;
        int iStyle = 0;
        try {
            StringTokenizer stok = new StringTokenizer(font, ",");
            szNames = stok.nextToken();
            String tmp = stok.nextToken();
            iSize = Integer.parseInt(stok.nextToken());
            if (tmp.equalsIgnoreCase("Font.BOLD")) {
                iStyle = 1;
            } else if (tmp.equalsIgnoreCase("Font.ITALIC")) {
                iStyle = 2;
            } else if (tmp.equalsIgnoreCase("Font.BOLD|Font.ITALIC") || tmp.equalsIgnoreCase("Font.ITALIC|Font.BOLD")) {
                iStyle = 3;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Couldn't parse font :" + font);
        }
        String[] szFontNames = szNames.split("\\|", -1);
        int i = 0;
        while (!(r = new FontUIResource(szFontNames[i], iStyle, iSize)).getFamily().equals(szFontNames[i]) && ++i < szFontNames.length) {
        }
        return r;
    }

    @Override
    public String getName() {
        return this.szThemeName;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.windowTitleFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.controlFont;
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.controlFont;
    }
}

