/*
 * Decompiled with CFR 0.152.
 */
package com.luugiathuy.apps.downloadmanager;

import com.luugiathuy.apps.downloadmanager.Downloader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpDownloader
extends Downloader {
    public HttpDownloader(URL url, File outputFolder, int numConnections) {
        super(url, outputFolder, numConnections);
        this.download();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(String info) {
        Object object = this.stateLock;
        synchronized (object) {
            this.errorInfo = info;
            System.out.println("ERROR: " + info);
            this.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fatalError(String info) {
        Object object = this.stateLock;
        synchronized (object) {
            this.errorInfo = info;
            System.out.println("FATAL ERROR: " + info);
            this.setState(4);
            this.mFatal = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection conn = null;
        try {
            try {
                int contentLength;
                conn = (HttpURLConnection)this.mURL.openConnection();
                conn.setConnectTimeout(10000);
                conn.connect();
                if (conn.getResponseCode() / 100 != 2) {
                    this.error("Downloader - " + conn.getResponseMessage());
                }
                if ((contentLength = conn.getContentLength()) < 1) {
                    this.error("Downloader - invalid length " + contentLength);
                }
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.mFileSize == -1) {
                        this.mFileSize = contentLength;
                        this.stateChanged();
                        System.out.println("File size: " + this.mFileSize);
                    }
                }
                if (this.getState() == 0) {
                    if (this.mListDownloadThread.size() == 0) {
                        if (this.mFileSize > 409600) {
                            int partSize = (this.mFileSize + this.mNumConnections - 1) / this.mNumConnections;
                            System.out.println("Part size: " + partSize);
                            int end = 0;
                            int i = 1;
                            while (i <= this.mNumConnections) {
                                int start = end;
                                end = Math.min(this.mFileSize, end + partSize);
                                HttpDownloadThread aThread = new HttpDownloadThread(i, this.mURL, new File(this.mOutputFolder, this.mFileName), start, end);
                                this.mListDownloadThread.add(aThread);
                                ++i;
                            }
                            assert (end == this.mFileSize);
                        } else {
                            HttpDownloadThread aThread = new HttpDownloadThread(1, this.mURL, new File(this.mOutputFolder, this.mFileName), 0, this.mFileSize);
                            this.mListDownloadThread.add(aThread);
                        }
                    } else {
                        int i = 0;
                        while (i < this.mListDownloadThread.size()) {
                            if (!((Downloader.DownloadThread)this.mListDownloadThread.get(i)).isFinished()) {
                                ((Downloader.DownloadThread)this.mListDownloadThread.get(i)).download();
                            }
                            ++i;
                        }
                    }
                }
                int i = 0;
                while (i < this.mListDownloadThread.size()) {
                    ((Downloader.DownloadThread)this.mListDownloadThread.get(i)).waitFinish();
                    ++i;
                }
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (this.getState() == 0) {
                        this.setState(2);
                    }
                }
            }
            catch (Exception e) {
                this.error("Downloader - " + e.getClass().getName() + ": " + e.getMessage());
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                finally {
                    this.isDead = true;
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            finally {
                this.isDead = true;
            }
        }
    }

    static /* synthetic */ void access$0(HttpDownloader httpDownloader, String string) {
        httpDownloader.error(string);
    }

    static /* synthetic */ void access$1(HttpDownloader httpDownloader, String string) {
        httpDownloader.fatalError(string);
    }

    private class HttpDownloadThread
    extends Downloader.DownloadThread {
        public HttpDownloadThread(int threadID, URL url, File outputFile, int startByte, int endByte) {
            super(threadID, url, outputFile, startByte, endByte);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block122: {
                block120: {
                    block117: {
                        block114: {
                            block111: {
                                block108: {
                                    in = null;
                                    raf = null;
                                    numRead = -1;
                                    if (this.mStartByte >= this.mEndByte) ** GOTO lbl131
                                    conn = (HttpURLConnection)this.mURL.openConnection();
                                    conn.setReadTimeout(5000);
                                    currentStartByte = this.mStartByte;
                                    byteRange = String.valueOf(this.mStartByte) + "-" + (this.mEndByte - 1);
                                    conn.setRequestProperty("Range", "bytes=" + byteRange);
                                    System.out.println("Thread " + this.mThreadID + "(Range=" + byteRange + ")");
                                    conn.connect();
                                    if (conn.getResponseCode() / 100 == 2) break block108;
                                    HttpDownloader.access$0(HttpDownloader.this, "Thread " + this.mThreadID + " - " + conn.getResponseMessage());
                                    try {
                                        if (raf != null) {
                                            try {
                                                var13_8 = HttpDownloader.this.rafLock;
                                                synchronized (var13_8) {
                                                    raf.close();
                                                }
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    finally {
                                        this.mIsDead = true;
                                        System.out.println("End thread " + this.mThreadID);
                                    }
                                    return;
                                }
                                contentRange = conn.getHeaderField("Content-Range");
                                if (contentRange != null && contentRange.startsWith("bytes ") && (sep = contentRange.indexOf(47)) != -1) break block111;
                                HttpDownloader.access$0(HttpDownloader.this, "Thread " + this.mThreadID + " - Missing or bad Content-Range syntax: " + contentRange);
                                try {
                                    if (raf != null) {
                                        try {
                                            e = HttpDownloader.this.rafLock;
                                            synchronized (e) {
                                                raf.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                finally {
                                    this.mIsDead = true;
                                    System.out.println("End thread " + this.mThreadID);
                                }
                                return;
                            }
                            responseRange = contentRange.substring("bytes ".length(), sep);
                            if (responseRange.equals(byteRange)) break block114;
                            HttpDownloader.access$0(HttpDownloader.this, "Thread " + this.mThreadID + " - Incorrect Content-Range: " + contentRange + " (" + responseRange + "), expected: " + byteRange);
                            try {
                                if (raf != null) {
                                    try {
                                        e = HttpDownloader.this.rafLock;
                                        synchronized (e) {
                                            raf.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            finally {
                                this.mIsDead = true;
                                System.out.println("End thread " + this.mThreadID);
                            }
                            return;
                        }
                        in = conn.getInputStream();
                        var10_39 = HttpDownloader.this.rafLock;
                        synchronized (var10_39) {
                            raf = new RandomAccessFile(this.mOutputFile, "rw");
                            raf.seek(currentStartByte);
                        }
                        data = new byte[4096];
                        while (HttpDownloader.this.getState() == 0 && (numRead = in.read(data, 0, 4096)) != -1) {
                            var11_40 = HttpDownloader.this.rafLock;
                            synchronized (var11_40) {
                                raf.write(data, 0, numRead);
                            }
                            this.mStartByte += numRead;
                            var11_40 = this.mStateLock;
                            synchronized (var11_40) {
                                HttpDownloader.this.downloaded(numRead);
                            }
                        }
lbl131:
                        // 2 sources

                        if (HttpDownloader.this.getState() != 1) break block117;
                        try {
                            if (raf != null) {
                                try {
                                    e = HttpDownloader.this.rafLock;
                                    synchronized (e) {
                                        raf.close();
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            this.mIsDead = true;
                            System.out.println("End thread " + this.mThreadID);
                        }
                        return;
                    }
                    try {
                        try {
                            if (this.mStartByte < this.mEndByte) {
                                HttpDownloader.access$0(HttpDownloader.this, "Thread " + this.mThreadID + " - Received incomplete file: " + numRead + "/" + this.mStartByte + "/" + this.mEndByte);
                                break block120;
                            }
                            if (this.mStartByte > this.mEndByte) {
                                HttpDownloader.access$1(HttpDownloader.this, "Thread " + this.mThreadID + " - File too long: " + numRead + "/" + this.mStartByte + "/" + this.mEndByte);
                                break block120;
                            }
                            var4_5 = this.mStateLock;
                            synchronized (var4_5) {
                                if (HttpDownloader.this.getState() == 0) {
                                    this.mIsFinished = true;
                                }
                            }
                        }
                        catch (IOException e) {
                            HttpDownloader.access$0(HttpDownloader.this, "Thread " + this.mThreadID + " - " + e.getClass().getName() + ": " + e.getMessage());
                            try {
                                if (raf != null) {
                                    try {
                                        e = HttpDownloader.this.rafLock;
                                        synchronized (e) {
                                            raf.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                break block122;
                            }
                            finally {
                                this.mIsDead = true;
                                System.out.println("End thread " + this.mThreadID);
                            }
                        }
                    }
                    catch (Throwable var12_41) {
                        try {
                            if (raf != null) {
                                try {
                                    e = HttpDownloader.this.rafLock;
                                    synchronized (e) {
                                        raf.close();
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            this.mIsDead = true;
                            System.out.println("End thread " + this.mThreadID);
                        }
                        throw var12_41;
                    }
                }
                try {
                    if (raf != null) {
                        try {
                            e = HttpDownloader.this.rafLock;
                            synchronized (e) {
                                raf.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    this.mIsDead = true;
                    System.out.println("End thread " + this.mThreadID);
                }
            }
        }
    }
}

