/*
 * Decompiled with CFR 0.152.
 */
package com.luugiathuy.apps.downloadmanager;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Observable;

public abstract class Downloader
extends Observable
implements Runnable {
    protected final URL mURL;
    protected final File mOutputFolder;
    protected final int mNumConnections;
    protected String errorInfo = null;
    protected final String mFileName;
    protected final Object stateLock = new Object();
    protected final Object rafLock = new Object();
    protected int mFileSize;
    protected int mState;
    protected boolean mFatal;
    protected int mDownloaded;
    protected final ArrayList<DownloadThread> mListDownloadThread;
    protected Thread t;
    protected volatile boolean isDead;
    protected static final int BLOCK_SIZE = 4096;
    protected static final int BUFFER_SIZE = 4096;
    protected static final int MIN_DOWNLOAD_SIZE = 409600;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETED = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;

    protected Downloader(URL url, File outputFolder, int numConnections) {
        this.mURL = url;
        this.mOutputFolder = outputFolder;
        this.mNumConnections = numConnections;
        String fileURL = url.getFile();
        this.mFileName = fileURL.substring(fileURL.lastIndexOf(47) + 1);
        System.out.println("File name: " + this.mFileName);
        this.mListDownloadThread = new ArrayList();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.stateLock;
        synchronized (object) {
            this.mFileSize = -1;
            this.mState = 0;
            this.mFatal = false;
            this.mDownloaded = 0;
            this.mListDownloadThread.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.mState != 0) {
                if (this.mFatal) {
                    this.cancel(true);
                    this.reset();
                } else {
                    this.setState(0);
                }
                this.download();
            }
        }
    }

    public void cancel(boolean wait) {
        this.setState(3);
        if (wait) {
            int i = 0;
            while (i < this.mListDownloadThread.size()) {
                try {
                    this.mListDownloadThread.get(i).waitFinish();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public String getURL() {
        return this.mURL.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileSize() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.mFileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        Object object = this.stateLock;
        synchronized (object) {
            return (float)this.mDownloaded / (float)this.mFileSize * 100.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorInfo() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.mState == 4) {
                return this.errorInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int value) {
        Object object = this.stateLock;
        synchronized (object) {
            this.mState = value;
            this.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.isDead && this.t != null) {
                new Throwable("Warning: Restart before thread downloader death").printStackTrace();
                try {
                    this.t.join();
                }
                catch (InterruptedException e) {
                    System.err.println("Warning: Unexpected interrupt:");
                    e.printStackTrace();
                }
            }
            this.t = new Thread(this);
            this.isDead = false;
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloaded(int value) {
        Object object = this.stateLock;
        synchronized (object) {
            this.mDownloaded += value;
            this.stateChanged();
        }
    }

    protected void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isHalted() {
        for (DownloadThread t : this.mListDownloadThread) {
            if (t.isHalted()) continue;
            return false;
        }
        return this.isDead;
    }

    protected abstract class DownloadThread
    implements Runnable {
        protected final int mThreadID;
        protected final URL mURL;
        protected final File mOutputFile;
        protected final Object mStateLock = new Object();
        protected int mStartByte;
        protected final int mEndByte;
        protected boolean mIsFinished;
        protected volatile boolean mIsDead;
        protected Thread mThread;

        public DownloadThread(int threadID, URL url, File outputFile, int startByte, int endByte) {
            this.mThreadID = threadID;
            this.mURL = url;
            this.mOutputFile = outputFile;
            this.mStartByte = startByte;
            this.mEndByte = endByte;
            this.mIsFinished = false;
            this.download();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished() {
            Object object = this.mStateLock;
            synchronized (object) {
                return this.mIsFinished;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download() {
            DownloadThread downloadThread = this;
            synchronized (downloadThread) {
                if (!this.mIsDead && this.mThread != null) {
                    new Throwable("Warning: Restart before thread death").printStackTrace();
                    try {
                        this.mThread.join();
                    }
                    catch (InterruptedException e) {
                        System.err.println("Warning: Unexpected interrupt:");
                        e.printStackTrace();
                    }
                }
                this.mThread = new Thread(this);
                this.mIsDead = false;
                this.mThread.start();
            }
        }

        public void waitFinish() throws InterruptedException {
            this.mThread.join();
        }

        public boolean isHalted() {
            return this.mIsDead;
        }
    }
}

