/*
 * Decompiled with CFR 0.152.
 */
package com.luugiathuy.apps.downloadmanager;

import com.luugiathuy.apps.downloadmanager.Downloader;
import com.luugiathuy.apps.downloadmanager.HttpDownloader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class DownloadManager {
    private static final int DEFAULT_NUM_CONN_PER_DOWNLOAD = 8;
    public static final String DEFAULT_OUTPUT_FOLDER = "";
    private int mNumConnPerDownload = 8;
    private ArrayList<Downloader> mDownloadList = new ArrayList();

    public int getNumConnPerDownload() {
        return this.mNumConnPerDownload;
    }

    public void SetNumConnPerDownload(int value) {
        this.mNumConnPerDownload = value;
    }

    public Downloader getDownload(int index) {
        return this.mDownloadList.get(index);
    }

    public void removeDownload(int index) {
        this.mDownloadList.remove(index);
    }

    public ArrayList<Downloader> getDownloadList() {
        return this.mDownloadList;
    }

    public Downloader createDownload(URL verifiedURL, File outputFolder) {
        System.out.println("Creating HttpDownloader with " + this.mNumConnPerDownload + " threads: " + verifiedURL);
        HttpDownloader fd = new HttpDownloader(verifiedURL, outputFolder, this.mNumConnPerDownload);
        this.mDownloadList.add(fd);
        return fd;
    }

    public static URL verifyURL(String fileURL) {
        if (!fileURL.toLowerCase().startsWith("http://") && !fileURL.toLowerCase().startsWith("https://")) {
            return null;
        }
        URL verifiedUrl = null;
        try {
            verifiedUrl = new URL(fileURL);
        }
        catch (Exception e) {
            return null;
        }
        if (verifiedUrl.getFile().length() < 2) {
            return null;
        }
        return verifiedUrl;
    }
}

