/*
 * Decompiled with CFR 0.152.
 */
package bundle;

import bundle.ConfigFile;
import bundle.Mandatory;
import hubolauncher.LauncherMode;
import hubolauncher.Utils;
import java.io.File;

public class GameInfo
extends ConfigFile {
    @Mandatory
    public String publisherID = null;
    private String publisherTitle = null;
    private String defaultDir = null;
    @Mandatory
    public String updateCheckURL = null;
    @Mandatory
    public String gameID = null;
    private String gameTitle = null;
    public String jvmArgs = null;
    private String jarFilePath = null;
    public int logoInsetX = 2;
    public int logoInsetY = 2;
    public float logoScaleX = 1.0f;
    public float logoScaleY = 1.0f;
    public int downloadProgressWeight = 75;
    public String templateVersionString = "M.MM";
    public String commandLineArgsFilePath = null;
    public InstallMode installMode = InstallMode.PUBLISHER;
    public LauncherMode launcherMode = LauncherMode.SAME_PROCESS;

    public GameInfo() {
        this.read();
    }

    public String getPublisherTitle() {
        return this.publisherTitle == null ? this.publisherID : this.publisherTitle;
    }

    public File getDefaultDir(InstallMode forInstallMode) {
        if (this.installMode == InstallMode.LOCAL) {
            return new File(".");
        }
        if (this.installMode == InstallMode.PUBLISHER) {
            if (this.defaultDir == null) {
                return new File(Utils.getDefaultRoot(), this.publisherID);
            }
            return new File(Utils.getDefaultRoot(), this.defaultDir);
        }
        if (this.defaultDir == null) {
            return new File(Utils.getDefaultRoot(), String.valueOf(this.publisherID) + "_" + this.gameID);
        }
        return new File(Utils.getDefaultRoot(), this.defaultDir);
    }

    public String getGameTitle() {
        return this.gameTitle == null ? this.gameID : this.gameTitle;
    }

    public String getJarFilePath() {
        return this.jarFilePath == null ? "game.jar" : this.jarFilePath;
    }

    public static enum InstallMode {
        PUBLISHER,
        SEPARATE,
        LOCAL;

    }
}

