/*
 * Decompiled with CFR 0.152.
 */
package bundle;

import bundle.Mandatory;
import hubolauncher.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;

public class ConfigFile {
    protected void read() {
        String fname;
        Class<?> c = this.getClass();
        URL url = c.getResource(fname = String.valueOf(c.getSimpleName()) + ".txt");
        if (url == null) {
            throw new RuntimeException("The file\"" + fname + "\" in the package \"" + c.getPackage().getName() + "\" is missing.");
        }
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new InputStreamReader(url.openStream()));
                HashMap<String, Field> fieldMap = new HashMap<String, Field>();
                HashSet<Field> mandatory = new HashSet<Field>();
                Field[] fieldArray = this.getClass().getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    f.setAccessible(true);
                    if (f.getAnnotation(Mandatory.class) != null) {
                        mandatory.add(f);
                    }
                    fieldMap.put(f.getName(), f);
                    ++n2;
                }
                while ((line = in.readLine()) != null) {
                    int sep = line.indexOf(61);
                    if (sep == -1) continue;
                    String fieldName = line.substring(0, sep).trim();
                    String valueString = line.substring(sep + 1).trim();
                    Field field = (Field)fieldMap.get(fieldName);
                    if (field == null) {
                        throw new RuntimeException("Bad config file \"" + fname + "\": No field named \"" + fieldName + "\"");
                    }
                    mandatory.remove(field);
                    this.set(fname, field, valueString);
                }
                if (!mandatory.isEmpty()) {
                    throw new RuntimeException("Bad config file \"" + fname + "\": Missing fields: " + mandatory);
                }
            }
            catch (IOException err) {
                throw new RuntimeException("Failed to read config file \"" + fname + "\"", err);
            }
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
    }

    private void set(String fname, Field field, String valueString) {
        block9: {
            try {
                Class<?> type = field.getType();
                if (type == String.class) {
                    field.set(this, valueString);
                    break block9;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    field.set(this, Boolean.parseBoolean(valueString));
                    break block9;
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    field.set(this, Integer.parseInt(valueString));
                    break block9;
                }
                if (type == Long.TYPE || type == Long.class) {
                    field.set(this, Long.parseLong(valueString));
                    break block9;
                }
                if (type == Double.TYPE || type == Double.class) {
                    field.set(this, Float.valueOf(Float.parseFloat(valueString)));
                    break block9;
                }
                if (type == Double.TYPE || type == Double.class) {
                    field.set(this, Double.parseDouble(valueString));
                    break block9;
                }
                if (type.isEnum()) {
                    field.set(this, this.enumValue(type.asSubclass(Enum.class), valueString));
                    break block9;
                }
                throw new RuntimeException("Unsupported field type " + type + " for " + field);
            }
            catch (Exception err) {
                throw new RuntimeException("Bad config file \"" + fname + "\"", err);
            }
        }
    }

    private Enum<?> enumValue(Class<? extends Enum> enumType, String value) {
        Enum r = Enum.valueOf(enumType, value);
        return r;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(this.getClass().getSimpleName()) + "{\n");
            Field[] fieldArray = this.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                sb.append(f.getName());
                sb.append(" = ");
                sb.append(String.valueOf(f.get(this)));
                sb.append("\n");
                ++n2;
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }
}

